/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.util.FileBlocks;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import com.excentis.products.byteblower.run.utils.LocalOutOfSequenceResultData;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LatencyDistributionCollector
implements RunScenario.Listener {
    public static String lastResults;
    private Map<String, FileBlocks.Writer> flows;
    private FileBlocks blocks;
    private FileBlocks.Writer index;

    public LatencyDistributionCollector() {
        try {
            File g = File.createTempFile("bb_latency_distribution", "bin");
            this.blocks = new FileBlocks(g.getAbsolutePath(), FileBlocks.MODE.WRITE);
            lastResults = g.getAbsolutePath();
            this.flows = new HashMap<String, FileBlocks.Writer>();
            this.index = this.blocks.createWriter();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
    }

    public void register(Context context) {
        context.listen(RunScenario.Listener.class, (Object)this);
    }

    private FileBlocks.Writer getflow(String name) {
        if (this.flows.containsKey(name)) {
            return this.flows.get(name);
        }
        FileBlocks.Writer result = this.blocks.createWriter();
        this.flows.put(name, result);
        try {
            StringBuilder newName = new StringBuilder();
            newName.append(result.id);
            newName.append(":!!:");
            newName.append(name);
            this.index.write(newName.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
        for (final RuntimeFbFlow aFlow : rtScenario.getRuntimeFlowsFb()) {
            aFlow.visitSnapshots(new RuntimeRx.SnapshotVisitor(){

                public void visit(RuntimePort port, LocalLatencyResultData[] trigger) {
                }

                public void visit(RuntimePort port, LocalTriggerResultData[] trigger) {
                }

                public void visit(RuntimePort port, LocalLatencyDistributionSnapshot trigger) {
                    FileBlocks.Writer g = LatencyDistributionCollector.this.getflow(aFlow.name());
                    ArrayList<Long> vals = new ArrayList<Long>();
                    vals.add(trigger.TimestampGet());
                    vals.add(trigger.RangeMinimumGet());
                    vals.add(trigger.RangeMaximumGet());
                    vals.add(1000000000L);
                    for (Long bucket : trigger.PacketCountBucketsGet()) {
                        vals.add(bucket);
                    }
                    vals.add(trigger.LatencyAverageGet());
                    ByteBuffer buffer = ByteBuffer.allocate(vals.size() * 8);
                    for (Long aval : vals) {
                        buffer.putLong(aval);
                    }
                    try {
                        g.write(buffer.array());
                        System.out.println("Saved the results to file");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void visit(RuntimePort port, LocalOutOfSequenceResultData[] trigger) {
                }
            });
        }
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        try {
            FileBlocks.Reader bb = this.blocks.createReader(0L);
            while (bb.hasNext()) {
                byte[] g = bb.read();
                String name = new String(g);
                System.out.format("Has results for %s %n", name);
            }
            this.blocks.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
    }
}

