/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.report.json.JsonEvent;
import com.excentis.products.byteblower.report.json.JsonScenario;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.run.actions.ConfigureLayer2;
import com.excentis.products.byteblower.run.actions.ConfigureLayer25;
import com.excentis.products.byteblower.run.actions.ConfigureLayer3;
import com.excentis.products.byteblower.run.actions.ConfigurePort;
import com.excentis.products.byteblower.run.actions.ConfigurePorts;
import com.excentis.products.byteblower.run.actions.CreateMeetingPoint;
import com.excentis.products.byteblower.run.actions.CreatePort;
import com.excentis.products.byteblower.run.actions.CreatePorts;
import com.excentis.products.byteblower.run.actions.CreateServer;
import com.excentis.products.byteblower.run.actions.CreateServers;
import com.excentis.products.byteblower.run.actions.PerformDhcp;
import com.excentis.products.byteblower.run.actions.PerformStatelessAutoconfiguration;
import com.excentis.products.byteblower.run.actions.StopScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeIPv4Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeIPv6Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer2Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeLayer3Configuration;
import com.excentis.products.byteblower.run.objects.RuntimeMeetingPoint;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import java.util.Date;
import java.util.List;

public class PortJsonEvents
implements CreateServer.Listener,
CreateMeetingPoint.Listener,
CreateServers.Listener,
CreatePort.Listener,
CreatePorts.Listener,
ConfigureLayer2.Listener,
ConfigureLayer25.Listener,
ConfigureLayer3.Listener,
PerformDhcp.Listener,
PerformStatelessAutoconfiguration.Listener,
ConfigurePort.Listener,
ConfigurePorts.Listener,
StopScenario.Listener {
    private final EventManager eventManager;

    public PortJsonEvents(JsonScenario scenario) {
        this.eventManager = new EventManager(scenario);
    }

    public void register(Context context) {
        context.listen(CreateServer.Listener.class, (Object)this);
        context.listen(CreateMeetingPoint.Listener.class, (Object)this);
        context.listen(CreateServers.Listener.class, (Object)this);
        context.listen(CreatePort.Listener.class, (Object)this);
        context.listen(CreatePorts.Listener.class, (Object)this);
        context.listen(ConfigureLayer2.Listener.class, (Object)this);
        context.listen(ConfigureLayer25.Listener.class, (Object)this);
        context.listen(ConfigureLayer3.Listener.class, (Object)this);
        context.listen(PerformDhcp.Listener.class, (Object)this);
        context.listen(PerformStatelessAutoconfiguration.Listener.class, (Object)this);
        context.listen(ConfigurePort.Listener.class, (Object)this);
        context.listen(ConfigurePorts.Listener.class, (Object)this);
        context.listen(StopScenario.Listener.class, (Object)this);
    }

    public void onServerCreationFailed(String serverUrl, CreateServer.Listener.ErrorType errorType, String errorMessage) {
        Date time = new Date();
        String message = "Failed to contact server at url " + serverUrl + " due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        ServerEvent event = new ServerEvent(time, message, severity, serverUrl);
        this.eventManager.persistIdEntity(event);
    }

    public void onServersCreated(RuntimeScenario rtScenario) {
    }

    public void onPortCreated(RuntimePort rtPort) {
    }

    public void onPortCreationFailed(RuntimePort rtPort, String errorMessage) {
        if (rtPort == null) {
            String message = "Trying to start scenario with unknown port: " + errorMessage;
            EventSeverity severity = EventSeverity.TEST_ERROR;
            PortEvent event = new PortEvent(new Date(), message, severity, null);
            this.eventManager.persistIdEntity(event);
            return;
        }
        ByteBlowerGuiPort mPort = rtPort.getModelPort();
        RuntimeServer rtServer = rtPort.getRuntimeServer();
        String interfaceString = rtPort.getInterfaceName();
        Date time = new Date();
        String portName = mPort.getName();
        String message = "Failed to create port '" + portName + "' on " + rtServer.getIPAddress() + "/" + interfaceString + " due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        PortEvent event = new PortEvent(time, message, severity, portName);
        this.eventManager.persistIdEntity(event);
    }

    public void onPortsCreated(RuntimeScenario rtScenario) {
    }

    public void onPortConfiguring(RuntimePort rtPort) {
    }

    public void onLayer2Configured(RuntimeLayer2Configuration rtL2Config) {
    }

    public void onLayer25Configured(List<RuntimeLayer25Configuration> rtL25ConfigList) {
    }

    public void onLayer3Configuring(RuntimePort rtPort) {
    }

    public void onDHCPPerformed(RuntimeLayer3Configuration rtL3Config) {
        Date time = new Date();
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        String portName = rtPort.getName();
        if (rtPort.isRuntimeLayer3Ipv4()) {
            RuntimeIPv4Configuration rtIpv4Config = (RuntimeIPv4Configuration)rtL3Config;
            String message = "DHCPv4 performed by port '" + portName + "' provided IPv4 address " + rtIpv4Config.getIPAddress();
            EventSeverity severity = EventSeverity.NETWORK_LOG;
            GenericEvent event = new GenericEvent(time, message, severity);
            this.eventManager.persistIdEntity(event);
        } else if (rtPort.isRuntimeLayer3Ipv6()) {
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtL3Config;
            String message = "DHCPv6 performed by port '" + portName + "' provided IPv6 address " + rtIpv6Config.getFullDhcpIPAddress()[0];
            EventSeverity severity = EventSeverity.NETWORK_LOG;
            GenericEvent event = new GenericEvent(time, message, severity);
            this.eventManager.persistIdEntity(event);
        }
    }

    public void onDHCPPerformFailed(RuntimeLayer3Configuration rtL3Config, String errorMessage) {
        Date time = new Date();
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        String portName = rtPort.getName();
        if (rtPort.isRuntimeLayer3Ipv4()) {
            String message = "DHCPv4 performed by port '" + portName + "' failed to provide IPv4 address due to following error\n" + errorMessage;
            EventSeverity severity = EventSeverity.NETWORK_WARNING;
            GenericEvent event = new GenericEvent(time, message, severity);
            this.eventManager.persistIdEntity(event);
        } else if (rtPort.isRuntimeLayer3Ipv6()) {
            String message = "DHCPv6 performed by port '" + portName + "' failed to provide IPv6 address due to following error\n" + errorMessage;
            EventSeverity severity = EventSeverity.NETWORK_WARNING;
            GenericEvent event = new GenericEvent(time, message, severity);
            this.eventManager.persistIdEntity(event);
        }
    }

    public void onStatelessAutoconfigurationPerformed(RuntimeLayer3Configuration rtL3Config) {
        Date time = new Date();
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        String portName = rtPort.getName();
        if (rtPort.isRuntimeLayer3Ipv6()) {
            RuntimeIPv6Configuration rtIpv6Config = (RuntimeIPv6Configuration)rtL3Config;
            String message = "SLAAC performed by port '" + portName + "' provided IPv6 address " + rtIpv6Config.getFullStatelessIPAddress()[0];
            EventSeverity severity = EventSeverity.NETWORK_LOG;
            GenericEvent event = new GenericEvent(time, message, severity);
            this.eventManager.persistIdEntity(event);
        }
    }

    public void onStatelessAutoconfigurationFailed(RuntimeLayer3Configuration rtL3Config, String errorMessage) {
        Date time = new Date();
        RuntimePort rtPort = rtL3Config.getRuntimePort();
        String portName = rtPort.getName();
        if (rtPort.isRuntimeLayer3Ipv6()) {
            String message = "SLAAC performed by port '" + portName + "' failed to provide IPv6 address due to following error\n" + errorMessage;
            EventSeverity severity = EventSeverity.NETWORK_WARNING;
            GenericEvent event = new GenericEvent(time, message, severity);
            this.eventManager.persistIdEntity(event);
        }
    }

    public void onPortConfigured(RuntimePort rtPort) {
        Date time = new Date();
        String portName = rtPort.getName();
        String message = "Port '" + portName + "' is configured.";
        EventSeverity severity = EventSeverity.TEST_LOG;
        PortEvent event = new PortEvent(time, message, severity, portName);
        this.eventManager.persistIdEntity(event);
    }

    public void onPortConfigurationFailed(RuntimePort rtPort, String errorMessage) {
        Date time = new Date();
        String portName = rtPort.getName();
        String message = "Failed to configure port '" + portName + "' due to following error:\n" + errorMessage;
        EventSeverity severity = EventSeverity.TEST_ERROR;
        PortEvent event = new PortEvent(time, message, severity, portName);
        this.eventManager.persistIdEntity(event);
    }

    public void onPortsConfigured(RuntimeScenario rtScenario) {
    }

    public void onScenarioStopped(RuntimeScenario rtScenario) {
        Date time = new Date();
        for (RuntimePort rtPort : rtScenario.getRuntimePorts()) {
            String portName = rtPort.getName();
            String message = "Port '" + portName + "' is destroyed.";
            EventSeverity severity = EventSeverity.TEST_LOG;
            PortEvent event = new PortEvent(time, message, severity, portName);
            this.eventManager.persistIdEntity(event);
        }
    }

    public void onLayer3Configured(RuntimeLayer3Configuration rtL3Config) {
    }

    public void onMeetingPointCreated(RuntimeMeetingPoint rtServer) {
    }

    public void onServerCreated(RuntimeBBServer rtServer) {
    }

    private static interface Event {
        public JsonEvent toStorage();
    }

    private static class EventManager {
        private final JsonScenario scenario;

        public EventManager(JsonScenario scenario) {
            this.scenario = scenario;
        }

        public void persistIdEntity(Event event) {
            JsonEvent evt = event.toStorage();
            if (!"TEST_LOG".equals(evt.getSeverity())) {
                this.scenario.addEvent(event.toStorage());
            }
        }
    }

    private static class GenericEvent
    implements Event {
        JsonEvent evt;

        public GenericEvent(Date time, String message, EventSeverity severity) {
            this.evt = new JsonEvent("", time, severity.name(), message, "");
        }

        @Override
        public JsonEvent toStorage() {
            return this.evt;
        }
    }

    private static class PortEvent
    implements Event {
        JsonEvent evt;

        public PortEvent(Date time, String message, EventSeverity severity, String portName) {
            this.evt = new JsonEvent(portName, time, severity.name(), message, "");
        }

        @Override
        public JsonEvent toStorage() {
            return this.evt;
        }
    }

    private static class ServerEvent
    implements Event {
        JsonEvent evt;

        public ServerEvent(Date time, String message, EventSeverity severity, String serverUrl) {
            this.evt = new JsonEvent(serverUrl, time, severity.name(), message, "");
        }

        @Override
        public JsonEvent toStorage() {
            return this.evt;
        }
    }
}

