/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.util;

import java.util.HashMap;

public class DirtySet<T> {
    private final HashMap<T, Integer> knownObjects;
    private final int dirtyCount;

    public DirtySet() {
        this(2);
    }

    public DirtySet(int minDirtyCount) {
        this.dirtyCount = minDirtyCount;
        this.knownObjects = new HashMap();
    }

    private boolean isSufficientDirty(int dirt) {
        return dirt >= this.dirtyCount;
    }

    public boolean isDirty(T val) {
        Integer dirt = this.knownObjects.get(val);
        return dirt != null && this.isSufficientDirty(dirt);
    }

    public boolean dirty(T val) {
        Integer dirt = this.knownObjects.get(val);
        if (dirt == null) {
            dirt = 0;
        }
        int newDirt = Math.min(dirt + 1, 0x7FFFFFFE);
        this.knownObjects.put(val, newDirt);
        return this.isSufficientDirty(newDirt);
    }
}

