/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.util;

import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.GrowingSizeModifier;
import com.excentis.products.byteblower.model.MultipleBurst;
import com.excentis.products.byteblower.model.RandomSizeModifier;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.TimingModifier;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFrameReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.MultipleBurstReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.FbFlowTemplateManager;
import com.excentis.products.byteblower.results.testdata.data.FbFrameManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.FlowManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplateFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeFixed;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeModifierGrowing;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeModifierRandom;
import com.excentis.products.byteblower.results.testdata.data.entities.FbStreamTimingModifier;
import com.excentis.products.byteblower.results.testdata.data.entities.FbStreamTimingModifierMultiburst;
import com.excentis.products.byteblower.results.testdata.data.entities.Flow;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;

public class FrameBlastingUtils {
    private TestDataPersistenceController pc;

    public FrameBlastingUtils(TestDataPersistenceController pc) {
        this.pc = pc;
    }

    public FbFlowInstance persistFbFlowInstance(FlowMeasurementReader mFlowInstanceReader) {
        ScenarioManager scenarioManager = new ScenarioManager(this.pc);
        FlowManager flowManager = new FlowManager(this.pc);
        FbFlowTemplateManager fbFlowTemplateManager = new FbFlowTemplateManager(this.pc);
        FlowInstanceManager flowInstanceManager = new FlowInstanceManager(this.pc);
        String scenarioName = mFlowInstanceReader.getScenario().getName();
        Scenario scenario = scenarioManager.find(scenarioName);
        Flow flow = flowManager.findOrCreate(mFlowInstanceReader.getFlow().getName());
        String flowTemplateName = mFlowInstanceReader.getFlowReader().getFlowTemplateName();
        FbFlowTemplate flowTemplate = fbFlowTemplateManager.find(flowTemplateName);
        if (flowTemplate == null) {
            FlowTemplate mFlowTemplate = mFlowInstanceReader.getFlow().getFlowTemplate();
            if (!(mFlowTemplate instanceof FrameBlastingFlow)) {
                throw new IllegalStateException("Unexpected RuntimeFbFlow flow template type " + mFlowTemplate.getClass().getSimpleName());
            }
            FrameBlastingFlow frameBlastingFlow = (FrameBlastingFlow)mFlowTemplate;
            FrameBlastingFlowReader reader = ReaderFactory.create((FrameBlastingFlow)frameBlastingFlow);
            flowTemplate = this.persistFlowTemplate(reader);
        }
        Integer positionInScenario = mFlowInstanceReader.getPositionInScenario();
        Long startTime = mFlowInstanceReader.getStartTimeInNanoseconds();
        Long duration = mFlowInstanceReader.getDurationInNanoseconds();
        Long frameCount = mFlowInstanceReader.getNumberOfFrames();
        String tos = mFlowInstanceReader.getTos();
        FbFlowInstance fbFlowInstance = new FbFlowInstance(scenario, flow, positionInScenario, startTime, duration, tos, flowTemplate, frameCount);
        flowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
        return fbFlowInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FbFlowTemplate persistFlowTemplate(FrameBlastingFlowReader reader) {
        FbFlowTemplateManager fbFlowTemplateManager = new FbFlowTemplateManager(this.pc);
        BaseEntityManager fbStreamTimingModifierManager = new BaseEntityManager(FbStreamTimingModifier.class, this.pc);
        FbFrameManager fbFrameManager = new FbFrameManager(this.pc);
        BaseEntityManager fbFlowTemplateFrameManager = new BaseEntityManager(FbFlowTemplateFrame.class, this.pc);
        String flowTemplateName = reader.getName();
        long frameInterval = reader.getFrameIntervalInNanoseconds();
        FbFlowTemplate fbFlowTemplate = new FbFlowTemplate(flowTemplateName, Long.valueOf(frameInterval));
        fbFlowTemplateManager.persistIdEntity((BaseEntity)fbFlowTemplate);
        TimingModifier mTimingModifier = reader.getTimingModifier();
        if (mTimingModifier != null) {
            if (!(mTimingModifier instanceof MultipleBurst)) throw new UnsupportedOperationException("Timing modifier " + mTimingModifier.getClass().getSimpleName() + " not supported by datagathering");
            MultipleBurstReader multipleBurstReader = ReaderFactory.create((MultipleBurst)((MultipleBurst)mTimingModifier));
            Long interBurstGap = multipleBurstReader.getInterBurstGapInNanoseconds();
            Long framesPerBurst = multipleBurstReader.getNumberOfFramesPerBurst();
            FbStreamTimingModifierMultiburst timingModifier = new FbStreamTimingModifierMultiburst(fbFlowTemplate, interBurstGap, framesPerBurst);
            fbStreamTimingModifierManager.persistIdEntity((BaseEntity)timingModifier);
        }
        for (FrameBlastingFrameReader fbFrameReader : reader.getFrameBlastingFrameReaders()) {
            FrameReader frameReader = fbFrameReader.getFrameReader();
            String frameName = frameReader.getName();
            Integer repeatCount = fbFrameReader.getWeight();
            Integer position = fbFrameReader.getIndexInContainer();
            FbFrame fbFrame = fbFrameManager.find(frameName);
            if (fbFrame == null) {
                FrameModifier frameModifier = reader.getFrameModifier();
                if (frameModifier != null) {
                    Integer maxSize;
                    Integer minSize;
                    frameName = this.composeUniqueModifiedFrameName(frameName, flowTemplateName);
                    if (frameModifier instanceof GrowingSizeModifier) {
                        GrowingSizeModifier growingSizeModifier = (GrowingSizeModifier)frameModifier;
                        minSize = growingSizeModifier.getMinSize();
                        maxSize = growingSizeModifier.getMaxSize();
                        Integer stepSize = growingSizeModifier.getStepSize();
                        Integer frameIteration = growingSizeModifier.getFrameIteration();
                        fbFrame = new FbFrameSizeModifierGrowing(frameName, minSize, maxSize, stepSize, frameIteration);
                    } else {
                        if (!(frameModifier instanceof RandomSizeModifier)) throw new UnsupportedOperationException("Frame modifier " + frameModifier.getClass().getSimpleName() + " not supported by datagathering");
                        RandomSizeModifier randomSizeModifier = (RandomSizeModifier)frameModifier;
                        minSize = randomSizeModifier.getMinSize();
                        maxSize = randomSizeModifier.getMaxSize();
                        fbFrame = new FbFrameSizeModifierRandom(frameName, minSize, maxSize);
                    }
                } else {
                    Integer frameSize = frameReader.getByteSize(ThroughputType.FRAME_ONLY);
                    fbFrame = new FbFrameSizeFixed(frameName, frameSize);
                }
                fbFrameManager.persistIdEntity((BaseEntity)fbFrame);
            }
            FbFlowTemplateFrame flowTemplateFrame = new FbFlowTemplateFrame(fbFlowTemplate, fbFrame, position, repeatCount);
            fbFlowTemplateFrameManager.persistIdEntity((BaseEntity)flowTemplateFrame);
        }
        return fbFlowTemplate;
    }

    private String composeUniqueModifiedFrameName(String frameName, String flowTemplateName) {
        return String.valueOf(frameName) + " (modified by " + flowTemplateName + ")";
    }
}

