/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.reader.FrameBlastingFrameReader;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import java.util.ArrayList;
import java.util.List;

class FBFlowConfig {
    String name;
    String flowTemplate;
    long startDelay;
    long duration;
    long packetInterval;
    long packets;
    List<Integer> packetSizes;
    String packetSizesInfo;
    Double intendedLoad;
    String tos;

    FBFlowConfig(RuntimeFbFlow fbFlow) {
        FrameBlastingFlow template = fbFlow.getModelFbFlowTemplate();
        this.name = fbFlow.getModelFlowReader().getName();
        this.flowTemplate = fbFlow.getFlowTemplateName();
        this.startDelay = fbFlow.getModelFlowInstanceReader().getStartTimeInNanoseconds();
        this.duration = fbFlow.getDuration();
        this.packets = fbFlow.getModelFlowInstanceReader().getNumberOfFrames();
        this.packetInterval = fbFlow.getModelFbFlowTemplate().getFrameInterval().getTimeInNanoseconds();
        this.packetSizes = new ArrayList<Integer>();
        for (FrameBlastingFrameReader frame : fbFlow.getModelFbFlowTemplateReader().getFrameBlastingFrameReaders()) {
            int ctr = 0;
            while (ctr < frame.getWeight()) {
                this.packetSizes.add(frame.getFrameReader().getByteSize(ThroughputType.FRAME_ONLY));
                ++ctr;
            }
        }
        if (template.getFrameModifier() != null) {
            this.packetSizes.clear();
        }
        this.packetSizesInfo = this.getPacketSizesString();
        this.intendedLoad = fbFlow.getModelFbFlowTemplateReader().getThroughput(DataRateUnit.BPS).doubleValue();
        this.tos = fbFlow.getModelFlowInstanceReader().getTos();
    }

    public String getPacketSizesString() {
        if (this.packetSizes.isEmpty()) {
            return "Mixed";
        }
        ArrayList<String> strSizes = new ArrayList<String>();
        for (Integer size : this.packetSizes) {
            strSizes.add(size.toString());
        }
        String result = String.join((CharSequence)" | ", strSizes);
        return result;
    }
}

