/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeVlanConfiguration;
import java.util.ArrayList;
import java.util.List;

public abstract class JsonByteBlowerPort {
    protected String name;
    protected String macAddress;
    protected String physicalInterface;
    protected String server;
    protected String serverVersion;
    protected String serverType;
    protected long mtu;
    protected List<Integer> vlans;

    public JsonByteBlowerPort(RuntimePort port) {
        this.name = port.getName();
        this.macAddress = port.getMacAddressString().toLowerCase().replace("-", ":");
        this.mtu = port.getModelPort().getMtu();
        this.serverVersion = port.getRuntimeServer().getVersion();
        this.serverType = port.isMobile() ? "MeetingPoint" : port.getRuntimeServer().getType();
        this.physicalInterface = port.getDockedInfo();
        this.server = port.getRuntimeServer().getName();
        this.vlans = new ArrayList<Integer>();
        for (RuntimeLayer25Configuration config : port.getRuntimeLayer25Configuration()) {
            if (!(config instanceof RuntimeVlanConfiguration)) continue;
            this.vlans.add(Integer.valueOf(((RuntimeVlanConfiguration)config).getVlanId()));
        }
    }
}

