/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.communication.api.HTTPResultData;
import com.excentis.products.byteblower.communication.api.HTTPResultDataList;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.report.json.ISO8601;
import com.excentis.products.byteblower.report.json.JsonHTTPSnapshot;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.utils.LocalHttpResultData;
import java.util.ArrayList;
import java.util.Collection;

class JsonHTTPSessionEnd {
    String portName;
    long rxBytes;
    long txBytes;
    String rxFirst;
    String rxLast;
    String txFirst;
    String txLast;
    Collection<JsonHTTPSnapshot> overTimeResults = new ArrayList<JsonHTTPSnapshot>();

    public JsonHTTPSessionEnd(RuntimeHttpServer server) {
        this.portName = server.getRuntimePort().getName();
    }

    public JsonHTTPSessionEnd(RuntimeHttpClient client) {
        this.portName = client.getRuntimePort().getName();
    }

    public void updateHttpResult(HTTPSessionInfo session, LocalHttpResultData cumulative) {
        this.rxBytes = cumulative.RxByteCountTotalGet();
        if (this.rxBytes > 0L) {
            this.rxFirst = ISO8601.instantString(cumulative.RxTimestampFirstGet());
            this.rxLast = ISO8601.instantString(cumulative.RxTimestampLastGet());
        }
        this.txBytes = cumulative.TxByteCountTotalGet();
        if (this.txBytes > 0L) {
            this.txFirst = ISO8601.instantString(cumulative.TxTimestampFirstGet());
            this.txLast = ISO8601.instantString(cumulative.TxTimestampLastGet());
        }
        HTTPResultDataList interval = session.ResultHistoryGet().IntervalGet();
        boolean DROP_LAST = true;
        int ctr = 0;
        while (ctr < interval.size() - 1) {
            HTTPResultData snap = interval.get(ctr);
            this.overTimeResults.add(new JsonHTTPSnapshot(snap));
            ++ctr;
        }
    }

    public void nullSnapshot(long now, long duation) {
        this.overTimeResults.add(new JsonHTTPSnapshot(now, duation));
    }

    public void dropRealtimeResults() {
        this.overTimeResults.clear();
    }
}

