/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.communication.api.HTTPRequestStatus;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.datapersistence.util.DirtySet;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.report.json.JsonHTTPSessionEnd;
import com.excentis.products.byteblower.report.json.JsonTcpSessionEnd;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import java.util.logging.Logger;

public class JsonHttpFlow {
    private transient DirtySet<RuntimeHttpFlow> dirtyHttpFlows = new DirtySet(3);
    String name;
    String flowTemplate;
    long startDelay;
    long duration;
    long size;
    String method;
    long ratelimit;
    String state;
    Long timeToFirstByte;
    Integer configuredTos;
    boolean l4sEnabled;
    JsonHTTPSessionEnd httpClient;
    JsonHTTPSessionEnd httpServer;
    JsonTcpSessionEnd tcpClient;
    JsonTcpSessionEnd tcpServer;

    public JsonHttpFlow() {
    }

    public JsonHttpFlow(RuntimeHttpFlow flow) {
        this.name = flow.name();
        this.flowTemplate = flow.getFlowTemplateName();
        FlowMeasurementReader measure = flow.getModelFlowInstanceReader();
        TcpFlowReader reader = flow.getModelHttpFlowTemplateReader();
        this.startDelay = measure.getStartTimeInNanoseconds();
        if (measure.getDuration() != null) {
            this.duration = measure.getDurationInNanoseconds();
        } else {
            this.size = (long)reader.getPayloadSizeInBytes();
        }
        this.method = "Unknown";
        if (reader.getRateLimit() >= 1.0f) {
            this.ratelimit = (long)reader.getRateLimit();
        }
        this.state = "Connecting";
        String hexTos = measure.getTos();
        this.configuredTos = 0;
        try {
            if (hexTos != null) {
                String shorter = hexTos.replace("0x", "");
                this.configuredTos = Integer.parseInt(shorter, 16);
            }
        }
        catch (NumberFormatException e) {
            Logger.getGlobal().warning("Unable to save TOS value");
        }
        this.l4sEnabled = reader.isL4S();
        this.httpClient = new JsonHTTPSessionEnd(flow.getRuntimeHttpClient());
        this.httpServer = new JsonHTTPSessionEnd(flow.getRuntimeHttpServer());
        this.tcpClient = new JsonTcpSessionEnd(flow.getRuntimeHttpClient());
        this.tcpServer = new JsonTcpSessionEnd(flow.getRuntimeHttpServer());
    }

    public void runUpdate(RuntimeHttpFlow rr) {
        this.state = rr.getRequestStatus().toString().toUpperCase();
        this.method = rr.getRuntimeHttpClient().getRequestedMethod().toString().toUpperCase();
        RuntimeHttpClient client = rr.getRuntimeHttpClient();
        HTTPSessionInfo serverSession = rr.getServerSessionInfo();
        HTTPRequestStatus status = rr.getRequestStatus();
        if (this.dirtyHttpFlows.isDirty(rr)) {
            return;
        }
        if (status == HTTPRequestStatus.Finished || status == HTTPRequestStatus.Stopped) {
            this.dirtyHttpFlows.dirty(rr);
        }
        if (status == HTTPRequestStatus.Configuration || status == HTTPRequestStatus.Scheduled || status == HTTPRequestStatus.Connecting || status == HTTPRequestStatus.Error) {
            long now = rr.BBTimestamp();
            long duration = 1000000000L;
            now -= 1000000000L;
            now = now / 1000000000L * 1000000000L;
            if (!client.hasSession()) {
                this.httpClient.nullSnapshot(now, 1000000000L);
            }
            if (serverSession == null) {
                this.httpServer.nullSnapshot(now, 1000000000L);
            }
        } else {
            if (client.hasSession()) {
                HTTPSessionInfo clientSession = client.getHTTPSessionInfo();
                this.httpClient.updateHttpResult(clientSession, client.getCumulativeHTTPResultData());
                this.tcpClient.updateResults(clientSession, client.getCumulativeTcpResultData());
            }
            if (serverSession != null) {
                this.httpServer.updateHttpResult(serverSession, rr.getServerCumulHTTP());
                this.tcpServer.updateResults(serverSession, rr.getServerCumulTcp());
            }
        }
    }

    public void dropRealtimeResults() {
        if (this.httpServer != null) {
            this.httpServer.dropRealtimeResults();
        }
        if (this.httpClient != null) {
            this.httpClient.dropRealtimeResults();
        }
        if (this.tcpServer != null) {
            this.tcpServer.dropRealtimeResults();
        }
        if (this.tcpClient != null) {
            this.tcpClient.dropRealtimeResults();
        }
    }
}

