/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.report.json.ISO8601;
import com.excentis.products.byteblower.report.json.JsonEvent;
import com.excentis.products.byteblower.report.json.JsonFbFlow;
import com.excentis.products.byteblower.report.json.JsonHttpFlow;
import com.excentis.products.byteblower.report.json.JsonIpv4Port;
import com.excentis.products.byteblower.report.json.JsonIpv6Port;
import com.excentis.products.byteblower.report.json.JsonPortGroup;
import com.excentis.products.byteblower.report.json.JsonRFC2544Flow;
import com.excentis.products.byteblower.report.json.JsonServer;
import com.excentis.products.byteblower.report.json.WirelessEndpointData;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class JsonScenario {
    private final String documentation = "https://api.byteblower.com/json";
    private String scenarioName;
    private String projectAuthor;
    private String runTitle;
    private String startMoment;
    private String endMoment;
    private String scenarioState = "STARTING";
    private String projectName;
    private String guiVersion;
    private List<JsonServer> servers = new ArrayList<JsonServer>();
    private List<JsonIpv4Port> ipv4Ports;
    private List<JsonIpv6Port> ipv6Ports;
    private List<JsonPortGroup> portGroups;
    private final transient HashMap<RuntimeFbFlow, JsonFbFlow> mappedFrameblasting;
    private final transient HashMap<RuntimeHttpFlow, JsonHttpFlow> mappedHttp;
    private List<JsonFbFlow> frameBlastingFlows;
    private List<JsonHttpFlow> httpFlows;
    private List<JsonRFC2544Flow> rfc2544Flows;
    private List<JsonEvent> events;
    private List<WirelessEndpointData> wifiStatistics = new ArrayList<WirelessEndpointData>();
    private Map<String, Double> lossConfiguration;

    public JsonScenario() {
        this.ipv4Ports = new ArrayList<JsonIpv4Port>();
        this.ipv6Ports = new ArrayList<JsonIpv6Port>();
        this.portGroups = new ArrayList<JsonPortGroup>();
        this.mappedFrameblasting = new HashMap();
        this.mappedHttp = new HashMap();
        this.frameBlastingFlows = new ArrayList<JsonFbFlow>();
        this.httpFlows = new ArrayList<JsonHttpFlow>();
        this.rfc2544Flows = new ArrayList<JsonRFC2544Flow>();
        this.events = new ArrayList<JsonEvent>();
        this.lossConfiguration = new HashMap<String, Double>();
        this.lossConfiguration.put("warningLevel", Double.parseDouble(ByteBlowerPreferences.getWarningLossLevel()));
        this.lossConfiguration.put("errorLevel", Double.parseDouble(ByteBlowerPreferences.getErrorLossLevel()));
    }

    private static <T> void merge(List<T> arr, T val, Comparator<T> comp) {
        int idx = 0;
        while (idx < arr.size() && comp.compare(arr.get(idx), val) < 0) {
            ++idx;
        }
        arr.add(idx, val);
    }

    public void addPort(RuntimePort port) {
        if (port.isRuntimeLayer3Ipv4()) {
            JsonScenario.merge(this.ipv4Ports, new JsonIpv4Port(port), (a, b) -> a.name.compareTo(b.name));
        } else if (port.isRuntimeLayer3Ipv6()) {
            JsonScenario.merge(this.ipv6Ports, new JsonIpv6Port(port), (a, b) -> a.name.compareTo(b.name));
        }
        RuntimeServer server = port.getRuntimeServer();
        JsonServer.add(server, this.servers);
    }

    public void details(RuntimeScenario rtScenario) {
        Scenario model = rtScenario.getModelScenario();
        this.scenarioName = model.getName();
        this.projectAuthor = model.getByteBlowerProject().getAuthor();
        this.runTitle = rtScenario.getRunTitle();
        this.startMoment = ISO8601.toString(new Date());
        this.scenarioState = "STARTING";
        this.projectName = model.getByteBlowerProject().getName();
        String projectVersion = model.getByteBlowerProject().getModelVersion();
        Version v = FrameworkUtil.getBundle(JsonScenario.class).getVersion();
        this.guiVersion = projectVersion;
        for (RuntimeScenario.RuntimePortGroup rtGroup : rtScenario.getPortGroups()) {
            JsonPortGroup aGroup = new JsonPortGroup(rtGroup);
            this.portGroups.add(aGroup);
        }
        this.portGroups.sort(null);
    }

    public void frameblastingFlows(List<RuntimeFbFlow> runtimeFlowsConfiguredFb) {
        for (RuntimeFbFlow flow : runtimeFlowsConfiguredFb) {
            JsonFbFlow json = new JsonFbFlow(flow);
            this.frameBlastingFlows.add(json);
            this.mappedFrameblasting.put(flow, json);
        }
    }

    public void httpFlows(List<RuntimeHttpFlow> flows) {
        for (RuntimeHttpFlow flow : flows) {
            JsonHttpFlow json = new JsonHttpFlow(flow);
            this.httpFlows.add(json);
            this.mappedHttp.put(flow, json);
        }
    }

    public void scenarioUpdate(RuntimeFbFlow fb) {
        JsonFbFlow mapped = this.mappedFrameblasting.get(fb);
        if (mapped != null) {
            mapped.runUpdate(fb);
        }
    }

    public void scenarioUpdate(RuntimeHttpFlow http) {
        JsonHttpFlow mapped = this.mappedHttp.get(http);
        if (mapped != null) {
            mapped.runUpdate(http);
        }
    }

    public void addNatDiscovery(RuntimePort rtTargetPort, RuntimePort rtResolverPort, String ipAddress, NatDiscovery.L4Protocol l4Protocol, Integer privateL4Port, Integer publicL4Port, NatDiscovery.NatDiscoveryParameters natDiscovery) {
        for (JsonIpv4Port port : this.ipv4Ports) {
            if (!port.name.equals(rtTargetPort.getName())) continue;
            port.addNAT(rtResolverPort, ipAddress, l4Protocol, privateL4Port, publicL4Port, natDiscovery);
        }
    }

    public void finish() {
        this.scenarioState = "FINISHED";
        this.endMoment = ISO8601.toString(new Date());
    }

    public void dropRealtimeResults() {
        for (JsonFbFlow jsonFbFlow : this.frameBlastingFlows) {
            jsonFbFlow.dropRealtimeResults();
        }
        for (JsonHttpFlow jsonHttpFlow : this.httpFlows) {
            jsonHttpFlow.dropRealtimeResults();
        }
        this.wifiStatistics.clear();
        this.events.clear();
    }

    public void addEvent(JsonEvent event) {
        this.events.add(event);
    }

    public WirelessEndpointData findWifi(String portName, String ifName) {
        for (WirelessEndpointData existing : this.wifiStatistics) {
            if (!ifName.equals(existing.networkInterface) || !portName.equals(existing.wirelessEndpoint)) continue;
            return existing;
        }
        WirelessEndpointData match = new WirelessEndpointData(ifName, portName, new WirelessEndpointData.Sample[0]);
        this.wifiStatistics.add(match);
        this.wifiStatistics.sort((first, second) -> {
            int result = first.networkInterface.compareTo(second.networkInterface);
            if (result == 0) {
                result = first.wirelessEndpoint.compareTo(second.wirelessEndpoint);
            }
            return result;
        });
        return match;
    }

    public void addWifiSample(String portName, String ifName, long timestamp, long rssi, String bssid, String ssid) {
        WirelessEndpointData.Sample base = new WirelessEndpointData.Sample(timestamp, bssid, ssid, rssi);
        this.findWifi(portName, ifName).add(base);
    }
}

