/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.communication.api.TCPResultData;
import com.excentis.products.byteblower.report.json.ISO8601;

class JsonTCPSnapshot {
    String timestamp;
    long duration;
    long congestionWindowMaximum;
    long congestionWindowMinimum;
    long congestionWindowCurrent;
    long rttMaximum;
    long rttCurrent;
    long rttMinimum;
    long receiverWindowMaximum;
    long receiverWindowCurrent;
    long receiverWindowMinimum;
    long slowRetransmissions;
    long fastRetransmissions;
    long rxHeader;
    long rxPayload;
    long rxTotal;
    long rxSegments;
    long rxSegmentsOutOfOrder;
    long txHeader;
    long txPayload;
    long txTotal;
    long txSegments;
    long localECNMarkings;
    long remoteECNMarkings;

    public JsonTCPSnapshot(TCPResultData interval) {
        this.timestamp = ISO8601.instantString(interval.TimestampGet());
        this.duration = interval.IntervalDurationGet();
        this.congestionWindowMaximum = interval.CongestionWindowMaximumGet();
        this.congestionWindowCurrent = interval.CongestionWindowCurrentGet();
        this.congestionWindowMinimum = interval.CongestionWindowMinimumGet();
        this.receiverWindowMaximum = interval.ReceiverWindowMaximumGet();
        this.receiverWindowCurrent = interval.ReceiverWindowCurrentGet();
        this.receiverWindowMinimum = interval.ReceiverWindowMinimumGet();
        this.rttMaximum = interval.RoundTripTimeMaximumGet();
        this.rttCurrent = interval.RoundTripTimeAverageGet();
        this.rttMinimum = interval.RoundTripTimeMinimumGet();
        this.localECNMarkings = interval.RxLocalCongestionNotificationCountGet();
        this.remoteECNMarkings = interval.RxRemoteCongestionNotificationCountGet();
        this.fastRetransmissions = interval.RetransmissionCountFastGet();
        this.slowRetransmissions = interval.RetransmissionCountSlowGet();
        this.rxHeader = interval.RxByteCountHeaderGet();
        this.rxPayload = interval.RxByteCountPayloadGet();
        this.rxTotal = interval.RxByteCountTotalGet();
        this.rxSegments = interval.RxSegmentCountTotalGet();
        this.rxSegmentsOutOfOrder = interval.RxSegmentCountOutOfOrderGet();
        this.txHeader = interval.TxByteCountHeaderGet();
        this.txPayload = interval.TxByteCountPayloadGet();
        this.txTotal = interval.TxByteCountTotalGet();
        this.txSegments = interval.TxSegmentCountTotalGet();
    }
}

