/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.communication.api.TCPResultData;
import com.excentis.products.byteblower.communication.api.TCPResultHistory;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.report.json.ISO8601;
import com.excentis.products.byteblower.report.json.JsonTCPSnapshot;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.utils.LocalTcpResultData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class JsonTcpSessionEnd {
    private static final transient Map<String, String> CaaNames = Map.of("None", "NONE", "SACK", "SACK", "New Reno", "NEWRENO", "New Reno (with cubic)", "NEWRENO_WITH_CUBIC", "SACK (with cubic)", "SACK_WITH_CUBIC");
    String portName;
    String caa;
    long congestionWindowMaximum;
    long congestionWindowMinimum;
    long rttMaximum;
    long rttAverage;
    long rttMinimum;
    long receiverWindowMaximum;
    long receiverWindowMinimum;
    Integer configuredWindowScale;
    Integer initialReceiveWindow;
    long slowRetransmissions;
    long fastRetransmissions;
    long rxHeader;
    long rxPayload;
    long rxTotal;
    long rxSegments;
    long rxSegmentsOutOfOrder;
    long txHeader;
    long txPayload;
    long txTotal;
    long txSegments;
    String synTx;
    String synRx;
    Collection<JsonTCPSnapshot> overTimeResults = new ArrayList<JsonTCPSnapshot>();

    public JsonTcpSessionEnd(RuntimeHttpClient runtimeHttpClient) {
        this.portName = runtimeHttpClient.getRuntimePort().getName();
        TcpFlow template = (TcpFlow)runtimeHttpClient.getRuntimeHttpFlow().getModelFlowTemplate();
        String baseCaaName = template.getTCPCongestionAvoidanceAlgorithm().toString();
        this.caa = CaaNames.getOrDefault(baseCaaName, "Uknown");
        this.initialReceiveWindow = this.initialRcvWindow(template);
        this.configuredWindowScale = template.getRcvWindowScale();
        this.synRx = null;
        this.synTx = null;
        if (runtimeHttpClient.getRuntimePort().isMobile()) {
            this.overTimeResults = null;
        }
    }

    public JsonTcpSessionEnd(RuntimeHttpServer runtimeHttpClient) {
        this.portName = runtimeHttpClient.getRuntimePort().getName();
        TcpFlow template = runtimeHttpClient.getModelHttpFlowTemplate();
        String baseCaaName = template.getTCPCongestionAvoidanceAlgorithm().toString();
        this.caa = CaaNames.getOrDefault(baseCaaName, "Uknown");
        this.configuredWindowScale = template.getRcvWindowScale();
        this.initialReceiveWindow = this.initialRcvWindow(template);
        this.synRx = null;
        this.synTx = null;
        if (runtimeHttpClient.getRuntimePort().isMobile()) {
            this.overTimeResults = null;
        }
    }

    private int initialRcvWindow(TcpFlow template) {
        int initialReceiveWindow = 0;
        try {
            initialReceiveWindow = Integer.parseInt(template.getWindowSize());
        }
        catch (NumberFormatException e) {
            Logger.getGlobal().log(Level.SEVERE, "Unknown BBP format, can't parse configured Window size");
        }
        return initialReceiveWindow;
    }

    public void updateResults(HTTPSessionInfo session, LocalTcpResultData cumulativeTcpResultData) {
        if (this.overTimeResults == null) {
            return;
        }
        this.congestionWindowMaximum = cumulativeTcpResultData.CongestionWindowMaximumGet();
        this.congestionWindowMinimum = cumulativeTcpResultData.CongestionWindowMinimumGet();
        this.fastRetransmissions = cumulativeTcpResultData.RetransmissionCountFastGet();
        this.receiverWindowMaximum = cumulativeTcpResultData.ReceiverWindowMaximumGet();
        this.receiverWindowMinimum = cumulativeTcpResultData.ReceiverWindowMinimumGet();
        this.rttAverage = cumulativeTcpResultData.RoundTripTimeAverageGet();
        this.rttMaximum = cumulativeTcpResultData.RoundTripTimeMaximumGet();
        this.rttMinimum = cumulativeTcpResultData.RoundTripTimeMinimumGet();
        this.rxHeader = cumulativeTcpResultData.RxByteCountHeaderGet();
        this.rxPayload = cumulativeTcpResultData.RxByteCountPayloadGet();
        this.rxSegments = cumulativeTcpResultData.RxSegmentCountTotalGet();
        this.rxSegmentsOutOfOrder = cumulativeTcpResultData.RxSegmentCountOutOfOrderGet();
        this.rxTotal = cumulativeTcpResultData.RxByteCountTotalGet();
        this.slowRetransmissions = cumulativeTcpResultData.RetransmissionCountSlowGet();
        if (cumulativeTcpResultData.NumberOfSynReceivedGet() > 0L) {
            this.synRx = ISO8601.instantString(cumulativeTcpResultData.TimestampSynReceivedGet());
        }
        if (cumulativeTcpResultData.NumberOfSynSentGet() > 0L) {
            this.synTx = ISO8601.instantString(cumulativeTcpResultData.TimestampSynSentGet());
        }
        this.txHeader = cumulativeTcpResultData.TxByteCountHeaderGet();
        this.txPayload = cumulativeTcpResultData.TxByteCountPayloadGet();
        this.txSegments = cumulativeTcpResultData.TxSegmentCountTotalGet();
        this.txTotal = cumulativeTcpResultData.TxByteCountTotalGet();
        TCPResultHistory results = session.TcpSessionInfoGet().ResultHistoryGet();
        int ctr = 0;
        while ((long)ctr < results.IntervalLengthGet() - 1L) {
            TCPResultData interval = results.IntervalGetByIndex((long)ctr);
            this.overTimeResults.add(new JsonTCPSnapshot(interval));
            ++ctr;
        }
    }

    public void dropRealtimeResults() {
        if (this.overTimeResults != null) {
            this.overTimeResults.clear();
        }
    }
}

