/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.json;

import com.excentis.products.byteblower.report.json.ISO8601;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WirelessEndpointData {
    protected String networkInterface;
    protected String wirelessEndpoint;
    protected List<Sample> overTimeResults = new ArrayList<Sample>();

    public WirelessEndpointData(String currentNetIF, String currentWep, Sample ... initialData) {
        this.networkInterface = currentNetIF;
        this.wirelessEndpoint = currentWep;
        this.overTimeResults = new ArrayList<Sample>(Arrays.asList(initialData));
    }

    void add(Sample sample) {
        boolean fresh;
        long mostRecent = Long.MIN_VALUE;
        if (this.overTimeResults.size() > 0) {
            Sample last = this.overTimeResults.get(this.overTimeResults.size() - 1);
            mostRecent = last.iTimestamp;
        }
        boolean bl = fresh = sample.iTimestamp > mostRecent;
        if (fresh) {
            this.overTimeResults.add(sample);
        }
    }

    static class Sample {
        protected String timestamp;
        protected transient long iTimestamp;
        protected String bssid;
        protected String ssid;
        protected long rssi;

        public Sample(long timestamp, String bssid, String ssid, long rssi) {
            this.timestamp = ISO8601.instantString(timestamp);
            this.iTimestamp = timestamp;
            this.bssid = bssid;
            this.ssid = ssid;
            this.rssi = rssi;
        }
    }
}

