/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.FrameUtil;
import com.excentis.products.byteblower.frame.ProtocolField;
import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;

public class FlagsField
extends ProtocolField {
    private BitSet flags;
    private Vector<String> fnames;
    private String delim = "|";

    public FlagsField(int s, String f) {
        super(s);
        this.fnames = new Vector(5);
        this.flags = new BitSet(s);
        StringTokenizer st = new StringTokenizer(f, this.delim);
        while (st.hasMoreTokens()) {
            this.fnames.addElement(st.nextToken());
        }
    }

    private FlagsField(int s) {
        super(s);
        this.fnames = new Vector();
        this.flags = new BitSet(s);
    }

    FlagsField(int s, int o, byte[] buffer, String f) {
        this(s, f);
        this.set(s, buffer, o);
    }

    public Object getValue() {
        return this.flags;
    }

    public String toString() {
        boolean nfirst = false;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            if (this.flags.get(i)) {
                if (nfirst) {
                    sb.append(this.delim);
                }
                nfirst = true;
                sb.append(this.fnames.elementAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public void set(String n) {
        if (n.indexOf(this.delim) != -1) {
            int i = 0;
            while (i < this.size) {
                this.flags.clear(i);
                ++i;
            }
        }
        StringTokenizer st = new StringTokenizer(n, this.delim);
        while (st.hasMoreTokens()) {
            String tmp = new String(st.nextToken());
            int i = 0;
            while (i < this.size) {
                if (tmp.equals(this.fnames.elementAt(i))) {
                    this.flags.set(i);
                }
                ++i;
            }
        }
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        int initialOffset = offset;
        if (bufsize < this.size) {
            return -1;
        }
        int i = 0;
        while (i < this.size) {
            if (FrameUtil.getBit(buffer, offset + i) != 0) {
                this.flags.set(i);
            } else {
                this.flags.clear(i);
            }
            ++i;
        }
        return initialOffset + this.size;
    }

    @Override
    public int dump(byte[] buffer, int offset) {
        int i = 0;
        while (i < this.size) {
            if (this.flags.get(i)) {
                FrameUtil.setBit(buffer, offset + i);
            } else {
                FrameUtil.resetBit(buffer, offset + i);
            }
            ++i;
        }
        return offset + this.size;
    }

    public void reset(String n) {
        StringTokenizer st = new StringTokenizer(n, this.delim);
        while (st.hasMoreTokens()) {
            String tmp = new String(st.nextToken());
            int i = 0;
            while (i < this.size) {
                if (tmp.equals(this.fnames.elementAt(i))) {
                    this.flags.clear(i);
                }
                ++i;
            }
        }
    }

    public Vector<String> getNames() {
        return this.fnames;
    }

    boolean get(String s) {
        int i = 0;
        while (i < this.size) {
            if (s.equals(this.fnames.elementAt(i))) {
                return this.flags.get(i);
            }
            ++i;
        }
        return false;
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        FlagsField flagsField = new FlagsField(this.getSize());
        flagsField.flags = (BitSet)this.flags.clone();
        flagsField.fnames = new Vector<String>(this.fnames);
        return flagsField;
    }
}

