/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.ICMPProtocol;
import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

class ICMPEcho
extends ICMPProtocol {
    private static final int IDENTIFIER = 0;
    private static final int SEQUENCE = 1;
    private static final int DATA = 2;
    private static final int PAYLOAD = 2;
    private static final String[] FIELD_NAMES = new String[]{"Identifier", "Sequence", "Data"};

    private ICMPEcho(int s) {
        super(s);
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new RawField(s - 32));
    }

    ICMPEcho(int s, int o, byte[] buffer) {
        this(s);
        this.set(s, buffer, o);
    }

    @Override
    public void setPayload(ProtocolField pf) {
        this.fields.set(2, pf);
    }

    @Override
    public ProtocolField getPayload() {
        return (ProtocolField)this.fields.get(2);
    }

    public Object getValue() {
        System.err.println("ICMPEcho::getValue missig!");
        return new Object();
    }

    @Override
    public void print() {
        System.out.println("ICMP Echo");
        int i = 0;
        while (i < this.fields.size()) {
            System.out.println(String.valueOf(FIELD_NAMES[i]) + ":" + this.fields.get(i));
            ++i;
        }
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    public String getIdentifier() {
        return ((ProtocolField)this.fields.get(0)).toString();
    }

    @Override
    public String getShortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getIdentifier());
        return sb.toString();
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        ICMPEcho icmpEcho = new ICMPEcho(this.getSize());
        icmpEcho.fields.clear();
        for (ProtocolField protoField : this.fields) {
            icmpEcho.fields.add(protoField.clone(this.icmp));
        }
        return icmpEcho;
    }
}

