/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.ICMPEcho;
import com.excentis.products.byteblower.frame.ICMPEchoReply;
import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

class ICMPPacket
extends ProtocolLayer {
    private static final int TYPE = 0;
    private static final int CODE = 1;
    private static final int CHECKSUM = 2;
    private static final int PAYLOAD = 3;
    private static final String[] FIELD_NAMES = new String[]{"TYPE", "CODE", "Checksum", "PAYLOAD"};

    public ICMPPacket() {
        this(32);
    }

    public ICMPPacket(int s) {
        super(s);
        this.fields.add(new IntegerField(8));
        this.fields.add(new IntegerField(8));
        this.fields.add(new IntegerField(16));
        this.fields.add(new RawField(0));
    }

    public ICMPPacket(int s, int o, byte[] buffer) {
        this(s);
        this.set(s, buffer, o);
    }

    public Object getValue() {
        System.err.println("ICMPPacket::getValue missig!");
        return new Object();
    }

    @Override
    public void setPayload(ProtocolField pf) {
        this.fields.set(3, pf);
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        offset = ((ProtocolField)this.fields.get(0)).set(bufsize - offset, buffer, offset);
        offset = ((ProtocolField)this.fields.get(1)).set(bufsize - offset, buffer, offset);
        offset = ((ProtocolField)this.fields.get(2)).set(bufsize - offset, buffer, offset);
        switch (this.getType()) {
            case 0: {
                this.fields.set(3, new ICMPEchoReply(this.size - 32, offset, buffer));
                break;
            }
            case 8: {
                this.fields.set(3, new ICMPEcho(this.size - 32, offset, buffer));
                break;
            }
            default: {
                this.fields.set(3, new RawField(this.size - 32, offset, buffer));
            }
        }
        return this.size;
    }

    public int getCode() {
        return ((IntegerField)this.fields.get(1)).getIntValue();
    }

    public void setCode(int i) {
        ((IntegerField)this.fields.get(1)).set(i);
    }

    public int getType() {
        return ((IntegerField)this.fields.get(0)).getIntValue();
    }

    public void setType(int i) {
        ((IntegerField)this.fields.get(0)).set(i);
    }

    @Override
    public ProtocolField getPayload() {
        return (ProtocolField)this.fields.get(3);
    }

    public void setCheckSum(int i) {
        ((IntegerField)this.fields.get(2)).set(i);
    }

    public int getCheckSum() {
        return ((IntegerField)this.fields.get(2)).getIntValue();
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    @Override
    public String getShortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getCode());
        sb.append(" ");
        sb.append(this.getType());
        return sb.toString();
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        ICMPPacket icmp = new ICMPPacket(this.getSize());
        icmp.fields.clear();
        for (ProtocolField protoField : this.fields) {
            icmp.fields.add(protoField.clone(icmp));
        }
        return icmp;
    }
}

