/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.FlagsField;
import com.excentis.products.byteblower.frame.FrameUtil;
import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.Ipv4AddressField;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

public class Ipv4Packet
extends ProtocolLayer {
    public static final int PROTO_ICMP = 1;
    public static final int PROTO_TCP = 6;
    public static final int PROTO_UDP = 17;
    private static final String[] PROTOCOL_NAMES = new String[]{"0", "ICMP", "2", "3", "4", "5", "TCP", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "UDP"};
    private static final int VERSION = 0;
    private static final int IHL = 1;
    private static final int TOS = 2;
    private static final int TOT_LEN = 3;
    private static final int ID = 4;
    private static final int FLAGS = 5;
    private static final int FRAGMENT = 6;
    private static final int TTL = 7;
    private static final int PROTOCOL = 8;
    private static final int H_CHECKSUM = 9;
    private static final int SOURCE = 10;
    private static final int DESTINATION = 11;
    private static final int PAYLOAD = 12;
    private static final String[] FIELD_NAMES = new String[]{"Version", "IHL", "TOS", "Total Length", "Identification", "IP Flags", "Fragment Offset", "TTL", "Protocol", "Header Checksum", "Source Address", "Dest. Address", "IP Payload"};
    public static final String FlagReserved = "Reserved";
    public static final String FlagDNF = "DNF";
    public static final String FlagMF = "MF";

    public Ipv4Packet() {
        super(0);
        this.fields.add(new IntegerField(4));
        this.fields.add(new IntegerField(4));
        this.fields.add(new IntegerField(8));
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new FlagsField(3, "Reserved|DNF|MF"));
        this.fields.add(new IntegerField(13));
        this.fields.add(new IntegerField(8));
        IntegerField temp = new IntegerField(8);
        temp.setLabels(PROTOCOL_NAMES);
        this.fields.add(temp);
        this.fields.add(new IntegerField(16));
        this.fields.add(new Ipv4AddressField(32));
        this.fields.add(new Ipv4AddressField(32));
        this.fields.add(new RawField(0));
        this.calcSize();
    }

    public Ipv4Packet(ProtocolLayer parent) {
        this();
        this.setParent(parent);
    }

    public void do_default() {
        this.setVersion(4);
        this.setIHL(5);
        this.setTOS(24);
        this.setLen(20);
        this.setId(632);
        this.setFlags("DM");
        this.setFragmentOffset(0);
        this.setTTL(254);
        this.setProtocol(17);
    }

    public Ipv4Packet(int bufsize, byte[] buffer, int o) {
        this();
        this.set(bufsize, buffer, o);
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        int initialOffset = offset;
        int used = 0;
        int i = 0;
        while (i <= 12) {
            offset = ((ProtocolField)this.fields.get(i)).set(bufsize - used, buffer, offset);
            used = offset - initialOffset;
            if (offset == -1 || used > bufsize) {
                return -1;
            }
            ++i;
        }
        this.calcSize();
        return initialOffset + used;
    }

    public void doCheckSum() {
        int size = this.getIHL() * 32;
        byte[] buffer = new byte[8192];
        this.setCheckSum(0);
        this.dump(buffer, 0);
        int cs = FrameUtil.calcCheckSum(buffer, size / 8);
        cs = FrameUtil.intFold(cs);
        cs = FrameUtil.complement(cs);
        this.setCheckSum(cs);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.fields.size()) {
            sb.append(this.fields.get(i));
            sb.append("-");
            ++i;
        }
        return sb.toString();
    }

    public Object getValue() {
        System.err.println("IPPacket::getValue() missing!");
        return new Object();
    }

    @Override
    public void setPayload(ProtocolField pf) {
        this.fields.set(12, pf);
        this.calcSize();
    }

    @Override
    public ProtocolField getPayload() {
        return (ProtocolField)this.fields.get(12);
    }

    public int getIHL() {
        return (Integer)((IntegerField)this.fields.get(1)).getValue();
    }

    public int getTOS() {
        return ((IntegerField)this.fields.get(2)).getIntValue();
    }

    public int getId() {
        return (Integer)((IntegerField)this.fields.get(4)).getValue();
    }

    public int getTTL() {
        return (Integer)((IntegerField)this.fields.get(7)).getValue();
    }

    public int getFragmentOffset() {
        return (Integer)((IntegerField)this.fields.get(6)).getValue();
    }

    public String getFlags() {
        return ((ProtocolField)this.fields.get(5)).toString();
    }

    public void setVersion(int i) {
        ((IntegerField)this.fields.get(0)).set(i);
    }

    public int getVersion() {
        return (Integer)((IntegerField)this.fields.get(0)).getValue();
    }

    public void setIHL(int i) {
        ((IntegerField)this.fields.get(1)).set(i);
    }

    public void setTOS(int i) {
        ((IntegerField)this.fields.get(2)).set(i);
    }

    public void setLen(int i) {
        ((IntegerField)this.fields.get(3)).set(i);
    }

    public int getLen() {
        return ((IntegerField)this.fields.get(3)).getIntValue();
    }

    public void setId(int i) {
        ((IntegerField)this.fields.get(4)).set(i);
    }

    public void resetFlags(String s) {
        ((FlagsField)this.fields.get(5)).reset(s);
    }

    public void setFlags(String s) {
        ((FlagsField)this.fields.get(5)).set(s);
    }

    public void setFragmentOffset(int i) {
        ((IntegerField)this.fields.get(6)).set(i);
    }

    public void setTTL(int i) {
        ((IntegerField)this.fields.get(7)).set(i);
    }

    public void setProtocol(int i) {
        ((IntegerField)this.fields.get(8)).set(i);
    }

    public int getProtocol() {
        return ((IntegerField)this.fields.get(8)).getIntValue();
    }

    public String getProtocolName() {
        return PROTOCOL_NAMES[this.getProtocol()];
    }

    public int getCheckSum() {
        return ((IntegerField)this.fields.get(9)).getIntValue();
    }

    public void setCheckSum(int i) {
        ((IntegerField)this.fields.get(9)).set(i);
    }

    public String getSourceAddress() {
        return ((ProtocolField)this.fields.get(10)).toString();
    }

    public String getDestinationAddress() {
        return ((ProtocolField)this.fields.get(11)).toString();
    }

    public void setSourceAddress(String s) {
        ((Ipv4AddressField)this.fields.get(10)).set(s);
    }

    public void setDestinationAddress(String s) {
        ((Ipv4AddressField)this.fields.get(11)).set(s);
    }

    @Override
    public ProtocolField getField(int i) {
        return (ProtocolField)this.fields.get(i);
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    @Override
    public String getShortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSourceAddress());
        sb.append("->");
        sb.append(this.getDestinationAddress());
        sb.append(" ");
        sb.append(this.getId());
        return sb.toString();
    }

    public void autoSetLength() {
        this.setLen(this.size / 8);
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        Ipv4Packet ipv4 = new Ipv4Packet((ProtocolLayer)parent);
        ipv4.fields.clear();
        for (ProtocolField protoField : this.fields) {
            ipv4.fields.add(protoField.clone(ipv4));
        }
        return ipv4;
    }
}

