/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.FrameUtil;
import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

public class UDPPacket
extends ProtocolLayer {
    private static final int SOURCE = 0;
    private static final int DESTINATION = 1;
    private static final int LENGTH = 2;
    private static final int CHECKSUM = 3;
    private static final int PAYLOAD = 4;
    private static final String[] FIELD_NAMES = new String[]{"Source Port", "Destination Port", "Length", "Checksum", "Payload"};

    public UDPPacket() {
        this(64);
    }

    public UDPPacket(ProtocolLayer parent) {
        this(64);
        this.setParent(parent);
    }

    private UDPPacket(int s) {
        super(s);
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new IntegerField(16));
        this.fields.add(new RawField(s - 64));
        this.calcSize();
    }

    public UDPPacket(int s, byte[] buffer, int o) {
        this(s);
        this.set(s, buffer, o);
    }

    public void doCheckSum() {
        int i;
        byte[] temp_ip = new byte[8192];
        byte[] temp_udp = new byte[8192];
        byte[] buffer = new byte[40];
        int cs = 0;
        if (this.parent == null) {
            return;
        }
        this.setCheckSum(0);
        this.parent.dump(temp_ip, 0);
        this.dump(temp_udp, 0);
        boolean ipv4 = this.parent instanceof Ipv4Packet;
        boolean ipv6 = this.parent instanceof Ipv6Packet;
        if (ipv4) {
            i = 0;
            while (i < 8) {
                buffer[i] = temp_ip[12 + i];
                ++i;
            }
            buffer[8] = 0;
            buffer[9] = temp_ip[9];
            cs = FrameUtil.calcCheckSum(buffer, 10);
            cs += this.size / 8;
        } else if (ipv6) {
            i = 0;
            while (i < 32) {
                buffer[i] = temp_ip[8 + i];
                ++i;
            }
            buffer[32] = 0;
            buffer[33] = 0;
            buffer[34] = temp_ip[4];
            buffer[35] = temp_ip[5];
            buffer[36] = 0;
            buffer[37] = 0;
            buffer[38] = 0;
            buffer[39] = temp_ip[6];
            cs = FrameUtil.calcCheckSum(buffer, 40);
        }
        int byteSize = this.size / 8;
        if (byteSize % 2 != 0) {
            temp_udp[byteSize] = 0;
            ++byteSize;
        }
        cs = FrameUtil.calcCheckSum(temp_udp, byteSize, cs);
        cs = FrameUtil.intFold(cs);
        cs = FrameUtil.complement(cs);
        this.setCheckSum(cs);
    }

    public void setCheckSum(int i) {
        ((IntegerField)this.fields.get(3)).set(i);
    }

    public int getCheckSum() {
        return ((IntegerField)this.fields.get(3)).getIntValue();
    }

    public void setSource(int i) {
        ((IntegerField)this.fields.get(0)).set(i);
    }

    public int getSource() {
        return ((IntegerField)this.fields.get(0)).getIntValue();
    }

    public void setDestination(int i) {
        ((IntegerField)this.fields.get(1)).set(i);
    }

    public int getDestination() {
        return ((IntegerField)this.fields.get(1)).getIntValue();
    }

    public void setLength(int i) {
        ((IntegerField)this.fields.get(2)).set(i);
    }

    public int getLength() {
        return ((IntegerField)this.fields.get(2)).getIntValue();
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        int initialOffset = offset;
        int used = 0;
        int i = 0;
        while (i <= 4) {
            offset = ((ProtocolField)this.fields.get(i)).set(bufsize - used, buffer, offset);
            used = offset - initialOffset;
            if (offset == -1 || used > bufsize) {
                return -1;
            }
            ++i;
        }
        this.calcSize();
        return initialOffset + used;
    }

    public void autoSetLength() {
        this.setLength(this.size / 8);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        int i = 0;
        while (i < this.fields.size()) {
            sb.append(this.fields.get(i));
            sb.append("-");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public Object getValue() {
        System.err.println("UDPPacket::getValue missing!");
        return new Object();
    }

    public void setPayload(String s) {
        RawField pf = new RawField(s);
        this.setPayload(pf);
    }

    @Override
    public void setPayload(ProtocolField pf) {
        if (this.fields.size() == 5) {
            this.fields.set(4, pf);
        } else {
            this.fields.add(pf);
        }
        this.calcSize();
    }

    @Override
    public ProtocolField getPayload() {
        if (this.fields.size() == 5) {
            return (ProtocolField)this.fields.get(4);
        }
        return null;
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    @Override
    public String getShortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSource());
        sb.append("->");
        sb.append(this.getDestination());
        return sb.toString();
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        UDPPacket udp = new UDPPacket((ProtocolLayer)parent);
        udp.fields.clear();
        for (ProtocolField protoField : this.fields) {
            udp.fields.add(protoField.clone(udp));
        }
        return udp;
    }
}

