/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.frame;

import com.excentis.products.byteblower.frame.FlagsField;
import com.excentis.products.byteblower.frame.IntegerField;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.ProtocolLayer;
import com.excentis.products.byteblower.frame.RawField;
import java.util.Arrays;
import java.util.List;

public class VlanPacket
extends ProtocolLayer {
    private static final int FIELD_PCP = 0;
    private static final int FIELD_DE = 1;
    private static final int FIELD_VID = 2;
    private static final int FIELD_PROTOCOL = 3;
    private static final int FIELD_PAYLOAD = 4;
    public static final int LAYER_BYTE_SIZE = 4;
    private static final int SIZE_PCP = 3;
    private static final int SIZE_DE = 1;
    private static final int SIZE_VID = 12;
    private static final int SIZE_PROTOCOL = 16;
    private static final String[] FIELD_NAMES = new String[]{"Priority Code Point", "Drop Eligible", "VLAN Identifier", "Protocol", "Layer 3"};

    public VlanPacket() {
        super(0);
        this.fields.add(new IntegerField(3));
        this.fields.add(new FlagsField(1, "Drop Eligible"));
        this.fields.add(new IntegerField(12));
        this.fields.add(new IntegerField(16));
        this.fields.add(new RawField(0));
        this.calcSize();
    }

    public VlanPacket(ProtocolLayer parent) {
        this();
        this.setParent(parent);
    }

    public VlanPacket(int bufsize, byte[] buffer, int o) {
        this();
        this.set(bufsize, buffer, o);
    }

    @Override
    public int set(int bufsize, byte[] buffer, int offset) {
        this.size = 0;
        int initialOffset = offset;
        int used = 0;
        int i = 0;
        while (i <= 4) {
            offset = ((ProtocolField)this.fields.get(i)).set(bufsize - used, buffer, offset);
            used = offset - initialOffset;
            ++i;
        }
        this.size = bufsize;
        return -1;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.fields.size()) {
            sb.append(this.fields.get(i));
            sb.append("-");
            ++i;
        }
        return sb.toString();
    }

    public byte getPCP() {
        return (byte)((IntegerField)this.fields.get(0)).getIntValue();
    }

    public boolean getDE() {
        return ((FlagsField)this.fields.get(1)).get(FIELD_NAMES[1]);
    }

    public short getVID() {
        return (short)((IntegerField)this.fields.get(2)).getIntValue();
    }

    public short getProtocol() {
        return (short)((IntegerField)this.fields.get(3)).getIntValue();
    }

    @Override
    public ProtocolField getPayload() {
        return (ProtocolField)this.fields.get(4);
    }

    public void setPCP(byte pcp) {
        ((IntegerField)this.fields.get(0)).set(pcp);
    }

    public void setDE(boolean de) {
        String flag = FIELD_NAMES[1];
        FlagsField field = (FlagsField)this.fields.get(1);
        if (de) {
            field.set(flag);
        } else {
            field.reset(flag);
        }
    }

    public void setVID(short vid) {
        ((IntegerField)this.fields.get(2)).set(vid);
    }

    public void setProtocol(int protocol) {
        ((IntegerField)this.fields.get(3)).set(protocol);
    }

    @Override
    public void setPayload(ProtocolField pf) {
        this.fields.set(4, pf);
        this.calcSize();
    }

    @Override
    public List<String> getFieldsNames() {
        return Arrays.asList(FIELD_NAMES);
    }

    @Override
    public String getShortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPCP());
        sb.append("->");
        sb.append(this.getDE());
        sb.append("->");
        sb.append(this.getVID());
        sb.append("->");
        sb.append(this.getProtocol());
        sb.append(" ");
        return sb.toString();
    }

    @Override
    public ProtocolField clone(ProtocolField parent) {
        VlanPacket vlan = new VlanPacket((ProtocolLayer)parent);
        vlan.fields.clear();
        for (ProtocolField protoField : this.fields) {
            vlan.fields.add(protoField.clone(parent));
        }
        return vlan;
    }
}

