/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.actions.advisor;

import com.excentis.products.byteblower.gui.actions.ExcentisCloudStatusAction;
import com.excentis.products.byteblower.gui.actions.ExcentisCloudStatusText;
import com.excentis.products.byteblower.gui.actions.RunTitleText;
import com.excentis.products.byteblower.gui.actions.file.ByteBlowerOpenAutoSaveAction;
import com.excentis.products.byteblower.gui.actions.file.ByteBlowerRecentProjectAction;
import com.excentis.products.byteblower.gui.actions.handlers.ByteBlowerFileHandler;
import com.excentis.products.byteblower.gui.actions.project.ProjectPropertiesAction;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.preferences.recent.RecentProjects;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.util.IOpenCloseListener;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ByteBlowerActionBarAdvisor
extends ActionBarAdvisor
implements IOpenCloseListener {
    private static ActionFactory.IWorkbenchAction newProject;
    private static ActionFactory.IWorkbenchAction openProject;
    private static ActionFactory.IWorkbenchAction closeProject;
    private static ActionFactory.IWorkbenchAction openAutoSave;
    private static ActionFactory.IWorkbenchAction projectProperties;
    private static ActionFactory.IWorkbenchAction saveProject;
    private static ActionFactory.IWorkbenchAction saveAsProject;
    private static ActionFactory.IWorkbenchAction exit;
    private static List<ActionFactory.IWorkbenchAction> recentProjectsActions;
    private static ActionFactory.IWorkbenchAction importAction;
    private static ActionFactory.IWorkbenchAction exportAction;
    private static ActionFactory.IWorkbenchAction undo;
    private static ActionFactory.IWorkbenchAction redo;
    private static ActionFactory.IWorkbenchAction newAction;
    private static ActionFactory.IWorkbenchAction cut;
    private static ActionFactory.IWorkbenchAction copy;
    private static ActionFactory.IWorkbenchAction paste;
    private static ActionFactory.IWorkbenchAction delete;
    private static ActionFactory.IWorkbenchAction aboutAction;
    private static IWorkbenchWindow workbenchWindow;
    private static MenuManager fileMenu;

    static {
        recentProjectsActions = new ArrayList<ActionFactory.IWorkbenchAction>();
    }

    public ByteBlowerActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    public void dispose() {
        ProjectSwitchNotifier.getInstance().removeOpenCloseListener((IOpenCloseListener)this);
        super.dispose();
    }

    protected void makeActions(IWorkbenchWindow window) {
        workbenchWindow = window;
        ByteBlowerFileHandler.New byteblowerFileNewHandler = new ByteBlowerFileHandler.New();
        newProject = byteblowerFileNewHandler.getFileAction(window);
        this.register((IAction)newProject);
        ByteBlowerFileHandler.Open byteblowerFileOpenHandler = new ByteBlowerFileHandler.Open();
        openProject = byteblowerFileOpenHandler.getFileAction(window);
        this.register((IAction)openProject);
        openAutoSave = new ByteBlowerOpenAutoSaveAction(window);
        this.register((IAction)openAutoSave);
        ByteBlowerFileHandler.Close byteblowerFileCloseHandler = new ByteBlowerFileHandler.Close();
        closeProject = byteblowerFileCloseHandler.getFileAction(window);
        this.register((IAction)closeProject);
        projectProperties = new ProjectPropertiesAction(window);
        this.register((IAction)projectProperties);
        ByteBlowerFileHandler.Save byteblowerFileSaveHandler = new ByteBlowerFileHandler.Save();
        saveProject = byteblowerFileSaveHandler.getFileAction(window);
        this.register((IAction)saveProject);
        ByteBlowerFileHandler.SaveAs byteblowerFileSaveAsHandler = new ByteBlowerFileHandler.SaveAs();
        saveAsProject = byteblowerFileSaveAsHandler.getFileAction(window);
        this.register((IAction)saveAsProject);
        importAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)importAction);
        exportAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)exportAction);
        int nofRecentprojects = ByteBlowerPreferences.getPreferences().getInt("NofRecentProjects", 0);
        recentProjectsActions.clear();
        int i = 0;
        while (i < nofRecentprojects) {
            ByteBlowerRecentProjectAction action = new ByteBlowerRecentProjectAction(window);
            recentProjectsActions.add(action);
            ++i;
        }
        exit = ActionFactory.QUIT.create(window);
        this.register((IAction)exit);
        undo = ActionFactory.UNDO.create(window);
        this.register((IAction)undo);
        redo = ActionFactory.REDO.create(window);
        this.register((IAction)redo);
        newAction = ActionFactory.NEW.create(window);
        newAction.setText("New");
        this.register((IAction)newAction);
        newAction.setEnabled(false);
        cut = ActionFactory.CUT.create(window);
        this.register((IAction)cut);
        copy = ActionFactory.COPY.create(window);
        this.register((IAction)copy);
        paste = ActionFactory.PASTE.create(window);
        this.register((IAction)paste);
        delete = ActionFactory.DELETE.create(window);
        this.register((IAction)delete);
        aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)aboutAction);
    }

    public static void refreshFileMenu() {
        if (fileMenu == null) {
            return;
        }
        fileMenu.removeAll();
        fileMenu.add((IAction)newProject);
        fileMenu.add((IAction)openProject);
        fileMenu.add((IAction)closeProject);
        fileMenu.add((IAction)openAutoSave);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)projectProperties);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)saveProject);
        fileMenu.add((IAction)saveAsProject);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)importAction);
        fileMenu.add((IContributionItem)new Separator());
        String[] recentProjects = RecentProjects.getRecentProjects();
        int nofRecentProjects = recentProjects.length;
        int i = 0;
        while (i < nofRecentProjects) {
            String recentProjectString = recentProjects[i];
            int currentSize = recentProjectsActions.size();
            if (i >= currentSize) {
                ByteBlowerRecentProjectAction action = new ByteBlowerRecentProjectAction(workbenchWindow);
                recentProjectsActions.add(action);
            }
            ByteBlowerRecentProjectAction recentProjectAction = (ByteBlowerRecentProjectAction)recentProjectsActions.get(i);
            recentProjectAction.setText(String.valueOf(i + 1) + " " + recentProjectString);
            recentProjectAction.setProjectFileName(recentProjectString);
            fileMenu.add((IAction)recentProjectAction);
            ++i;
        }
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)exit);
        fileMenu.update(true);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        fileMenu = new MenuManager("&File", "file");
        ByteBlowerActionBarAdvisor.refreshFileMenu();
        menuBar.add((IContributionItem)fileMenu);
        MenuManager editMenu = new MenuManager("&Edit", "edit");
        editMenu.add((IAction)undo);
        editMenu.add((IAction)redo);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)newAction);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)cut);
        editMenu.add((IAction)copy);
        editMenu.add((IAction)paste);
        editMenu.add((IContributionItem)new Separator());
        editMenu.add((IAction)delete);
        menuBar.add((IContributionItem)editMenu);
        MenuManager runMenu = new MenuManager("&Run", "idRunAdditions");
        menuBar.add((IContributionItem)runMenu);
        MenuManager windowMenu = new MenuManager("&Window", "idWindowAdditions");
        MenuManager showViewMenu = new MenuManager("Show &View", "idShowView");
        showViewMenu.add((IContributionItem)new GroupMarker("additions"));
        windowMenu.add((IContributionItem)showViewMenu);
        menuBar.add((IContributionItem)windowMenu);
        MenuManager wizardMenu = new MenuManager("Wi&zard", "idWizardAdditions");
        menuBar.add((IContributionItem)wizardMenu);
        MenuManager helpMenu = new MenuManager("&Help", "help");
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        helpMenu.add((IAction)aboutAction);
        menuBar.add((IContributionItem)helpMenu);
    }

    protected void fillCoolBar(ICoolBarManager coolBarManager) {
        coolBarManager.add((IContributionItem)new GroupMarker("ByteBlowerFile_GroupMarker"));
        ToolBarManager fileToolBar = new ToolBarManager(coolBarManager.getStyle());
        fileToolBar.add((IAction)newProject);
        fileToolBar.add((IAction)openProject);
        fileToolBar.add((IAction)closeProject);
        fileToolBar.add((IContributionItem)new Separator());
        fileToolBar.add((IAction)saveProject);
        fileToolBar.add((IAction)saveAsProject);
        fileToolBar.add((IContributionItem)new Separator());
        fileToolBar.add((IAction)undo);
        fileToolBar.add((IAction)redo);
        fileToolBar.add((IContributionItem)new Separator());
        fileToolBar.add((IAction)newAction);
        fileToolBar.add((IContributionItem)new Separator());
        fileToolBar.add((IAction)cut);
        fileToolBar.add((IAction)copy);
        fileToolBar.add((IAction)paste);
        fileToolBar.add((IContributionItem)new Separator());
        fileToolBar.add((IAction)delete);
        fileToolBar.add((IContributionItem)new Separator());
        fileToolBar.add((IContributionItem)new RunTitleText("RunTitleText_ID"));
        coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)fileToolBar, "org.eclipse.ui.workbench.file"));
    }

    private void populateCloudToolbar(ICoolBarManager coolBarManager) {
        ToolBarManager excentisCloudToolBar = new ToolBarManager(coolBarManager.getStyle());
        excentisCloudToolBar.add((IAction)new ExcentisCloudStatusAction());
        excentisCloudToolBar.add((IContributionItem)new ExcentisCloudStatusText());
        coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)excentisCloudToolBar, "main1"));
    }

    public void projectOpenedOrClosed(ByteBlowerProject project) {
        ByteBlowerActionBarAdvisor.refreshFileMenu();
    }
}

