/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.actions.run.scenario;

import com.excentis.products.byteblower.gui.actions.ShowViewMenuFactory;
import com.excentis.products.byteblower.gui.model.reader.ScenarioGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.RefreshConfigurationJob;
import com.excentis.products.byteblower.gui.runner.GuiRunner;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.IOpenCloseListener;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RunScenario
implements IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate,
IActionDelegate2,
IOpenCloseListener {
    static final int RECENT_SCENARIO_COUNT = 5;
    private IAction action;
    private boolean updateWaiting = false;
    private Object updateLock = new Object();

    public RunScenario() {
        ProjectSwitchNotifier.getInstance().addOpenCloseListener((IOpenCloseListener)this);
        this.updateState();
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        if (this.fillRecentScenarioList(menu) > 0) {
            new MenuItem(menu, 2);
        }
        ShowViewMenuFactory.showView(menu, "Scenario...", "com.excentis.products.byteblower.gui.views.scenario.ScenarioView");
        return menu;
    }

    private int fillRecentScenarioList(Menu menu) {
        int recentCount = 0;
        if (!ByteBlowerGuiResourceController.getInstance().isOpen()) {
            return 0;
        }
        for (Scenario scenario : GuiRunner.getInstance().getRecentScenarioList()) {
            MenuItem item = new MenuItem(menu, 0);
            ScenarioGuiReader reader = GuiReaderFactory.create((Scenario)scenario);
            Image object = reader.getImage();
            if (object instanceof Image) {
                item.setImage(object);
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Scenario recentScenario;
                    ScenarioReader scenarioReader;
                    MenuItem menuItem;
                    Object itemData;
                    if (e.widget instanceof MenuItem && (itemData = (menuItem = (MenuItem)e.widget).getData()) instanceof Scenario && !(scenarioReader = ReaderFactory.create((Scenario)(recentScenario = (Scenario)itemData))).hasErrorStatus()) {
                        GuiRunner.getInstance().scheduleScenario(recentScenario);
                    }
                }
            });
            item.setText(scenario.getName());
            item.setData((Object)scenario);
            if (++recentCount >= 5) break;
        }
        return recentCount;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        String errorMessage;
        Scenario scenarioToRun = GuiRunner.getInstance().getMostRecentScenario();
        boolean foundScenario = scenarioToRun != null;
        boolean canPickValid = false;
        if (foundScenario) {
            ScenarioReader reader = ReaderFactory.create((Scenario)scenarioToRun);
            canPickValid = !reader.hasErrorStatus();
            errorMessage = String.valueOf(scenarioToRun.getName()) + " : The last launched Scenario is invalid.";
            errorMessage = String.valueOf(errorMessage) + "\nPlease look in the Solution tab for hints to get this fixed.";
        } else if (this.onlyOneScenarioInProject()) {
            foundScenario = true;
            Collection<Scenario> scenarios = this.getProjectScenarios();
            scenarioToRun = scenarios.iterator().next();
            ScenarioReader reader = ReaderFactory.create((Scenario)scenarioToRun);
            canPickValid = !reader.hasErrorStatus();
            errorMessage = "No valid scenerario";
            errorMessage = String.valueOf(errorMessage) + "\nPlease look in the Solution tab for hints to get this fixed.";
        } else {
            errorMessage = "Can't pick a scenario";
        }
        if (foundScenario && canPickValid) {
            GuiRunner.getInstance().scheduleScenario(scenarioToRun);
        } else {
            if (foundScenario) {
                MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                mb.setMessage(errorMessage);
                mb.open();
            }
            IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                win.getActivePage().showView("com.excentis.products.byteblower.gui.views.SolutionView");
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
        this.action = action;
        action.setEnabled(false);
        GuiRunner.getInstance().addListener(new GuiRunner.ActiveJobListener(){

            public void activeScenarioJobChanged() {
                RunScenario.this.updateState();
            }

            public void activeScenarioPaused(GuiRunner.Resumer resume) {
            }

            public void activeScenarioResumed() {
            }
        });
    }

    public void updateState() {
        if (this.action == null) {
            return;
        }
        Scenario mostRecentScenario = GuiRunner.getInstance().getMostRecentScenario();
        boolean mostRecentAvailable = mostRecentScenario != null;
        boolean enable = ByteBlowerGuiResourceController.getInstance().isOpen() && (mostRecentAvailable || this.isValidSingleScenario()) && !GuiRunner.getInstance().isRunning() && !RefreshConfigurationJob.isRunning();
        this.action.setEnabled(enable);
    }

    private Collection<Scenario> getProjectScenarios() {
        ByteBlowerProject project = ProjectSwitchNotifier.getInstance().getCurrentProject();
        if (project == null) {
            return Collections.emptyList();
        }
        return project.getScenario();
    }

    private boolean isValidSingleScenario() {
        Collection<Scenario> toPickFrom = this.getProjectScenarios();
        if (1 == toPickFrom.size()) {
            Scenario first = toPickFrom.iterator().next();
            ScenarioReader reader = ReaderFactory.create((Scenario)first);
            return !reader.hasErrorStatus();
        }
        return false;
    }

    private boolean onlyOneScenarioInProject() {
        return 1 == this.getProjectScenarios().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferredUpdate() {
        boolean alreadyWaiting;
        Object object = this.updateLock;
        synchronized (object) {
            alreadyWaiting = this.updateWaiting;
            this.updateWaiting = true;
        }
        if (alreadyWaiting) {
            return;
        }
        Job doUpdate = new Job("updating the run button"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                Object object = RunScenario.this.updateLock;
                synchronized (object) {
                    RunScenario.this.updateWaiting = false;
                }
                RunScenario.this.updateState();
                return Status.OK_STATUS;
            }
        };
        doUpdate.setSystem(true);
        doUpdate.setPriority(50);
        doUpdate.schedule(50L);
    }

    public void projectOpenedOrClosed(ByteBlowerProject project) {
        this.updateState();
        if (project == null) {
            return;
        }
        EContentAdapter g = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                RunScenario.this.deferredUpdate();
            }
        };
        project.eAdapters().add((Object)g);
    }
}

