/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.history.operations.status;

import com.excentis.products.byteblower.gui.history.operations.status.ByteBlowerStatusContainer;
import com.excentis.products.byteblower.gui.history.operations.status.SimpleQueue;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.impl.EByteBlowerObjectImpl;
import com.excentis.products.byteblower.model.impl.EByteBlowerObjectUpdater;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerStatusWrapper;
import com.excentis.products.byteblower.status.model.ByteBlowerStatus;
import com.excentis.products.byteblower.utils.cloud.CloudStatusPoller;
import com.excentis.products.byteblower.utils.cloud.ExcentisCloudStatus;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.ui.statushandlers.StatusManager;

public class StatusUpdater
extends Job
implements CloudStatusPoller.ICLoudListener {
    private static StatusUpdater instance;
    private static ByteBlowerProject currentProject;
    SimpleQueue<EByteBlowerObject> dirtyObjects;
    private ExcentisCloudStatus previousCloudStatus = null;

    public static StatusUpdater getInstance() {
        if (instance == null) {
            instance = new StatusUpdater();
        }
        return instance;
    }

    public void update() {
        this.update(currentProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(ByteBlowerProject project) {
        EByteBlowerObjectUpdater updater;
        EByteBlowerObjectUpdater eByteBlowerObjectUpdater = updater = EByteBlowerObjectImpl.updater;
        synchronized (eByteBlowerObjectUpdater) {
            if (project != currentProject) {
                ByteBlowerStatusContainer.getInstance().clear();
                currentProject = project;
            }
            if (project != null) {
                int maxLevel = updater.getMaxLevel();
                int level = 1;
                while (level <= maxLevel) {
                    BasicEList siblingDirties = updater.getDirtyLevel(level);
                    this.updateLevel((BasicEList<EByteBlowerObject>)siblingDirties);
                    ++level;
                }
            }
            updater.clear();
        }
    }

    private synchronized void updateLevel(BasicEList<EByteBlowerObject> levelObjects) {
        for (EByteBlowerObject dirtyObject : levelObjects) {
            if (!this.filter(dirtyObject)) continue;
            this.addDirtyObject(dirtyObject);
        }
    }

    private boolean filter(EByteBlowerObject dirtyObject) {
        EByteBlowerObjectReader reader = ReaderFactory.create((EByteBlowerObject)dirtyObject);
        ByteBlowerProject project = reader.getProject();
        return project == currentProject || project == null;
    }

    private synchronized void addDirtyObject(EByteBlowerObject dirtyObject) {
        this.getDirtyObjects().put(dirtyObject);
        this.schedule();
    }

    public StatusUpdater() {
        super("Status Updater Job");
    }

    private SimpleQueue<EByteBlowerObject> getDirtyObjects() {
        if (this.dirtyObjects == null) {
            this.dirtyObjects = new SimpleQueue();
        }
        return this.dirtyObjects;
    }

    private synchronized boolean isEmpty() {
        return this.getDirtyObjects().isEmpty();
    }

    private synchronized EByteBlowerObject harvestFirstDirtyObject() {
        EByteBlowerObject object = this.getDirtyObjects().get();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        EByteBlowerObjectUpdater updater;
        EByteBlowerObjectUpdater eByteBlowerObjectUpdater = updater = EByteBlowerObjectImpl.updater;
        synchronized (eByteBlowerObjectUpdater) {
            while (!this.isEmpty()) {
                EByteBlowerObject dirtyObject = this.harvestFirstDirtyObject();
                this.updateStatus(dirtyObject);
            }
        }
        return Status.OK_STATUS;
    }

    private void updateStatus(EByteBlowerObject dirtyObject) {
        List newStatuses;
        EByteBlowerObjectController controller = ControllerFactory.create((EByteBlowerObject)dirtyObject);
        EByteBlowerObjectController.StatusChange change = controller.getStatusChange();
        if (change == null) {
            return;
        }
        Command attachStatuses = controller.updateStatusesCommand(change);
        attachStatuses.execute();
        List oldStatuses = change.getOldStatuses();
        if (oldStatuses != null) {
            for (ByteBlowerStatus status : oldStatuses) {
                ByteBlowerStatusWrapper wrapper = new ByteBlowerStatusWrapper("com.excentis.products.byteblower.model.reader", status, false);
                StatusManager.getManager().handle((IStatus)wrapper, 0);
            }
        }
        if ((newStatuses = change.getNewStatuses()) != null) {
            for (ByteBlowerStatus status : newStatuses) {
                ByteBlowerStatusWrapper wrapper = new ByteBlowerStatusWrapper("com.excentis.products.byteblower.model.reader", status, true);
                StatusManager.getManager().handle((IStatus)wrapper, 2);
            }
        }
    }

    public void showCloudStatusOnScenariosAndBatches() {
        CloudStatusPoller.getInstance().register((CloudStatusPoller.ICLoudListener)this);
    }

    public void cloudUpdate(CloudStatusPoller.CloudStatusUpdate update) {
        if (currentProject != null && !update.status().equals((Object)this.previousCloudStatus)) {
            this.previousCloudStatus = update.status();
            for (Scenario scenario : currentProject.getScenario()) {
                scenario.setNeedsUpdate(1);
            }
            for (Batch batch : currentProject.getBatch()) {
                batch.setNeedsUpdate(1);
            }
            StatusUpdater.getInstance().update();
        }
    }
}

