/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.jface.viewers.AbstractComboBoxCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.IComboBoxCellEditorTextProvider;
import com.excentis.products.byteblower.gui.jface.viewers.IComboBoxCellEditorValueProvider;
import com.excentis.products.byteblower.object.control.EmbeddedString;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

abstract class BaseComboBoxCellEditor<ItemType>
extends AbstractComboBoxCellEditor {
    private static final int defaultStyle = 0;
    private IComboBoxCellEditorTextProvider<ItemType> comboBoxCellEditorTextProvider;
    private IComboBoxCellEditorValueProvider<ItemType> comboBoxCellEditorValueProvider;
    private ItemType[] items;
    private int selection;
    private CCombo comboBox;
    private EmbeddedString[] prependItems;

    protected BaseComboBoxCellEditor(IComboBoxCellEditorTextProvider<ItemType> comboBoxCellEditorTextProvider, IComboBoxCellEditorValueProvider<ItemType> comboBoxCellEditorValueProvider) {
        this.setStyle(0);
        Assert.isNotNull(comboBoxCellEditorTextProvider);
        Assert.isNotNull(comboBoxCellEditorValueProvider);
        this.comboBoxCellEditorTextProvider = comboBoxCellEditorTextProvider;
        this.comboBoxCellEditorValueProvider = comboBoxCellEditorValueProvider;
        this.items = null;
        this.selection = -1;
        this.prependItems = new EmbeddedString[0];
    }

    protected BaseComboBoxCellEditor(IComboBoxCellEditorTextProvider<ItemType> comboBoxCellEditorTextProvider, IComboBoxCellEditorValueProvider<ItemType> comboBoxCellEditorValueProvider, Composite parent, int style) {
        super(parent, style);
        Assert.isNotNull(comboBoxCellEditorTextProvider);
        Assert.isNotNull(comboBoxCellEditorValueProvider);
        this.comboBoxCellEditorTextProvider = comboBoxCellEditorTextProvider;
        this.comboBoxCellEditorValueProvider = comboBoxCellEditorValueProvider;
        this.items = null;
        this.selection = -1;
        this.prependItems = new EmbeddedString[0];
    }

    BaseComboBoxCellEditor(IComboBoxCellEditorTextProvider<ItemType> comboBoxCellEditorTextProvider, IComboBoxCellEditorValueProvider<ItemType> comboBoxCellEditorValueProvider, Composite parent, ItemType[] items) {
        this(comboBoxCellEditorTextProvider, comboBoxCellEditorValueProvider, parent, 0, items);
    }

    BaseComboBoxCellEditor(IComboBoxCellEditorTextProvider<ItemType> comboBoxCellEditorTextProvider, IComboBoxCellEditorValueProvider<ItemType> comboBoxCellEditorValueProvider, Composite parent, int style, ItemType[] items) {
        this(comboBoxCellEditorTextProvider, comboBoxCellEditorValueProvider, parent, style);
        this.setItems(items);
        this.prependItems = new EmbeddedString[0];
    }

    BaseComboBoxCellEditor(IComboBoxCellEditorTextProvider<ItemType> comboBoxCellEditorTextProvider, IComboBoxCellEditorValueProvider<ItemType> comboBoxCellEditorValueProvider, Composite parent, int style, ItemType[] items, EmbeddedString[] prependItems) {
        this(comboBoxCellEditorTextProvider, comboBoxCellEditorValueProvider, parent, style);
        this.setItems(items);
        this.setPrependItems(prependItems == null ? new EmbeddedString[]{} : prependItems);
    }

    protected CCombo getCombo() {
        return this.comboBox;
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.populateComboBoxItems();
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                BaseComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                BaseComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                BaseComboBoxCellEditor.this.selection = BaseComboBoxCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BaseComboBoxCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    protected ItemType[] getItems() {
        return this.items;
    }

    protected void setItems(ItemType[] items) {
        Assert.isNotNull(items);
        this.items = items;
        this.populateComboBoxItems();
    }

    protected ItemType getItem(int selection) {
        if (this.items != null && selection >= 0 && selection < this.items.length) {
            return this.items[selection];
        }
        return null;
    }

    public void setPrependItems(EmbeddedString[] prependItems) {
        Assert.isNotNull((Object)prependItems);
        this.prependItems = prependItems;
        this.populateComboBoxItems();
    }

    protected EmbeddedString getPrependItem(int selection) {
        if (this.prependItems != null && selection >= 0 && selection < this.prependItems.length) {
            return this.prependItems[selection];
        }
        return null;
    }

    protected int getIndexOf(ItemType value) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] == value) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private int getIndexOfPrependItem(EmbeddedString value) {
        if (this.prependItems != null) {
            int i = 0;
            while (i < this.prependItems.length) {
                if (this.prependItems[i] == value) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected Object doGetValue() {
        if (this.selection >= this.prependItems.length) {
            return this.comboBoxCellEditorValueProvider.doGetValue(this, this.selection - this.prependItems.length);
        }
        if (this.selection == -1) {
            return this.comboBoxCellEditorValueProvider.doGetNoValue(this);
        }
        return this.comboBoxCellEditorValueProvider.doGetPrependValue(this, this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.comboBox != null ? 1 : 0) != 0);
        this.selection = value instanceof EmbeddedString ? this.getIndexOfPrependItem((EmbeddedString)value) : this.prependItems.length + this.comboBoxCellEditorValueProvider.getIndex(this, value);
        this.comboBox.select(this.selection);
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int startIndex = 0;
            if (this.prependItems != null) {
                while (startIndex < this.prependItems.length) {
                    this.comboBox.add((String)this.prependItems[startIndex].get(), startIndex);
                    ++startIndex;
                }
            }
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.comboBoxCellEditorTextProvider.getString(this.items[i], i), startIndex + i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    protected boolean isCorrect(Object newValue) {
        boolean thisCorrect;
        boolean superCorrect = super.isCorrect(newValue);
        boolean bl = thisCorrect = newValue == null || newValue instanceof String || newValue instanceof EmbeddedString && this.getIndexOfPrependItem((EmbeddedString)newValue) >= 0 || this.comboBoxCellEditorValueProvider.isCorrectValue(this, newValue);
        return superCorrect && thisCorrect;
    }

    private void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            if (this.items.length > 0 && this.selection >= this.prependItems.length && this.selection < this.prependItems.length + this.items.length) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection - this.prependItems.length]));
            } else if (this.prependItems != null && this.prependItems.length > 0 && this.selection > 0 && this.selection < this.prependItems.length) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.prependItems[this.selection]));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }
}

