/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.gui.jface.viewers.AbstractModularComboBoxCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.IComboBoxCellEditorItemProvider;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

abstract class BaseModularComboBoxCellEditor<ItemType>
extends AbstractModularComboBoxCellEditor {
    private AbstractComboBoxCellEditorItemProvider<ItemType> comboBoxItemProvider;
    private int selection;
    private CCombo comboBox;
    private static final int defaultStyle = 0;

    protected BaseModularComboBoxCellEditor(AbstractComboBoxCellEditorItemProvider<ItemType> comboBoxItemProvider, Composite parent) {
        this(comboBoxItemProvider, parent, 0);
        this.setActivationStyle(1);
    }

    protected BaseModularComboBoxCellEditor(AbstractComboBoxCellEditorItemProvider<ItemType> comboBoxItemProvider, Composite parent, int style) {
        super(parent, style);
        Assert.isNotNull(comboBoxItemProvider);
        this.comboBoxItemProvider = comboBoxItemProvider;
        this.comboBoxItemProvider.setBaseModularComboBoxCellEditor(this);
    }

    protected BaseModularComboBoxCellEditor(AbstractComboBoxCellEditorItemProvider<ItemType> comboBoxItemProvider) {
        this.setStyle(0);
        Assert.isNotNull(comboBoxItemProvider);
        this.comboBoxItemProvider = comboBoxItemProvider;
        this.comboBoxItemProvider.setBaseModularComboBoxCellEditor(this);
    }

    protected IComboBoxCellEditorItemProvider<ItemType> getComboBoxItemProvider() {
        return this.comboBoxItemProvider;
    }

    private void comboBoxItemProviderUpdated() {
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.populateComboBoxItems();
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                BaseModularComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                BaseModularComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                BaseModularComboBoxCellEditor.this.selection = BaseModularComboBoxCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BaseModularComboBoxCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return this.comboBoxItemProvider.getValue(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.comboBox != null && this.comboBoxItemProvider.isValid(value) ? 1 : 0) != 0);
        this.selection = this.comboBoxItemProvider.getValueIndex(value);
        this.comboBox.select(this.selection);
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.comboBoxItemProvider != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.comboBoxItemProvider.getItemsLength()) {
                this.comboBox.add(this.comboBoxItemProvider.getItemString(i), i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    private void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            int itemsLength = this.comboBoxItemProvider.getItemsLength();
            if (itemsLength > 0 && this.selection >= 0 && this.selection < itemsLength) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBoxItemProvider.getItem(this.selection)));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    public static abstract class AbstractComboBoxCellEditorItemProvider<ItemType>
    implements IComboBoxCellEditorItemProvider<ItemType> {
        private BaseModularComboBoxCellEditor<ItemType> modularComboBoxCellEditor;

        private void setBaseModularComboBoxCellEditor(BaseModularComboBoxCellEditor<ItemType> modularComboBoxCellEditor) {
            this.modularComboBoxCellEditor = modularComboBoxCellEditor;
            this.itemsUpdated();
        }

        private void unsetBaseModularComboBoxCellEditor() {
            this.modularComboBoxCellEditor = null;
        }

        protected void itemsUpdated() {
            if (this.modularComboBoxCellEditor != null) {
                this.modularComboBoxCellEditor.comboBoxItemProviderUpdated();
            }
        }
    }
}

