/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import java.math.BigInteger;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class BigIntegerCellEditor
extends TextCellEditor {
    private static final Logger LOGGER = Logger.getGlobal();
    private BigInteger minInteger = null;
    private BigInteger maxInteger = null;

    public BigIntegerCellEditor(Composite parent, BigInteger maxInt) {
        this(parent, null, maxInt);
    }

    public BigIntegerCellEditor(Composite parent, BigInteger minInt, BigInteger maxInt) {
        super(parent);
        if (minInt == null) {
            minInt = BigInteger.valueOf(Long.MIN_VALUE);
        }
        if (maxInt == null) {
            maxInt = BigInteger.valueOf(Long.MAX_VALUE);
        }
        this.init(minInt, maxInt);
    }

    private void init(BigInteger minInt, BigInteger maxInt) {
        this.minInteger = minInt;
        this.maxInteger = maxInt;
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                try {
                    if (!result.isEmpty()) {
                        BigInteger binteger = new BigInteger(result);
                        e.doit = e.doit && (BigIntegerCellEditor.this.minInteger == null || binteger.compareTo(BigIntegerCellEditor.this.minInteger) >= 0);
                        e.doit = e.doit && (BigIntegerCellEditor.this.maxInteger == null || binteger.compareTo(BigIntegerCellEditor.this.maxInteger) <= 0);
                    }
                }
                catch (Exception exception) {
                    e.doit = false;
                }
            }
        });
    }

    protected void editOccured(ModifyEvent e) {
        super.editOccured(e);
        if (this.isValueValid()) {
            this.text.setForeground(null);
        } else {
            this.text.setForeground(new Color(null, 255, 0, 0));
        }
    }

    public Object doGetValue() {
        String valueString = (String)super.doGetValue();
        if (valueString == "") {
            return null;
        }
        try {
            BigInteger bigInteger = new BigInteger(valueString);
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void doSetValue(Object value) {
        if (value instanceof BigInteger) {
            String result = ((BigInteger)value).toString();
            super.doSetValue((Object)result);
        } else {
            LOGGER.info("ERROR : Value is no BigInteger !");
        }
    }
}

