/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class IntegerCellEditor
extends TextCellEditor {
    private Integer min;
    private Integer max;

    public IntegerCellEditor(Composite parent, Integer maxInt) {
        this(parent, maxInt, null);
    }

    public IntegerCellEditor(Composite parent, Integer maxInt, Integer minInt) {
        super(parent);
        this.min = minInt;
        this.max = maxInt;
        if (this.max != null) {
            Text text = (Text)this.getControl();
            String maxString = Integer.toString(this.max);
            text.setTextLimit(maxString.length());
        }
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                if (result.isEmpty()) {
                    e.doit = true;
                } else {
                    try {
                        Integer.valueOf(result);
                        e.doit = true;
                    }
                    catch (Exception exception) {
                        e.doit = false;
                    }
                }
            }
        });
    }

    protected void editOccured(ModifyEvent e) {
        super.editOccured(e);
        Text t = (Text)e.widget;
        String value = t.getText();
        if (this.isValueValid(value)) {
            this.text.setForeground(null);
        } else {
            this.text.setForeground(ByteBlowerColor.red);
        }
    }

    private boolean isValueTooSmall(Integer integer) {
        return this.min != null && integer.compareTo(this.min) < 0;
    }

    private boolean isValueTooBig(Integer integer) {
        return this.max != null && integer.compareTo(this.max) > 0;
    }

    private boolean isValueValid(String value) {
        if (value.isEmpty()) {
            return false;
        }
        Integer integer = Integer.valueOf(value);
        return !this.isValueTooSmall(integer) && !this.isValueTooBig(integer);
    }

    public Object doGetValue() {
        String valueString = (String)super.doGetValue();
        if (valueString.isEmpty()) {
            return null;
        }
        Integer integer = Integer.valueOf(valueString);
        if (this.isValueTooSmall(integer)) {
            return this.min;
        }
        if (this.isValueTooBig(integer)) {
            return this.max;
        }
        return integer;
    }

    public void doSetValue(Object value) {
        if (!(value instanceof Integer)) {
            System.out.println("ERROR : Value is no Integer!");
            return;
        }
        super.doSetValue((Object)((Integer)value).toString());
    }
}

