/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.model.reader.MacAddressReader;
import org.eclipse.jface.viewers.ICellEditorValidator;

class MacAddressValidator
implements ICellEditorValidator {
    MacAddressValidator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String isValid(Object value) {
        String byteString = "";
        int dotPos = 0;
        int dotCount = 0;
        int sumCheck = 0;
        boolean continueParsing = true;
        if (value instanceof MacAddressReader) {
            return null;
        }
        try {
            String valueString = (String)value;
            if (valueString.matches("00-00-00-00-00-00")) {
                return "mac address matches 00-00-00-00-00-00";
            }
            if (valueString.matches("FF-FF-FF-FF-FF-FF")) {
                return "mac address matches FF-FF-FF-FF-FF-FF";
            }
            if (valueString.endsWith("-")) {
                return "INVALID MAC ADDRESS : ENDS WITH DOT";
            }
            while (true) {
                if (!continueParsing) {
                    if (dotCount == 5) break;
                    return "INVALID IP ADDRESS : NO 5 DOTS";
                }
                dotPos = valueString.indexOf("-");
                if (dotPos != -1) {
                    ++dotCount;
                    byteString = valueString.substring(0, dotPos);
                    valueString = valueString.substring(dotPos + 1, valueString.length());
                } else {
                    byteString = valueString;
                    valueString = "";
                    continueParsing = false;
                }
                if (dotCount > 5) {
                    return "INVALID MAC ADDRESS : TOO MANY DOTS";
                }
                int intByte = Integer.parseInt(byteString, 16);
                if (intByte > 255) {
                    return "INVALID MAC ADDRESS : BYTE TOO BIG";
                }
                sumCheck += intByte;
            }
            if (sumCheck != 0) return null;
            return "INVALID IP ADDRESS : all bytes are 0";
        }
        catch (NumberFormatException exception) {
            return exception.getMessage();
        }
    }
}

