/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.jface.viewers;

import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class ShortCellEditor
extends TextCellEditor {
    private static final Logger LOGGER = Logger.getGlobal();
    private short min;
    private short max;

    public ShortCellEditor(Composite parent, Short minVal, Short maxVal) {
        super(parent);
        this.min = minVal;
        this.max = maxVal;
        int textLimit = Short.toString(maxVal).length();
        this.text.setTextLimit(textLimit);
    }

    protected void editOccured(ModifyEvent e) {
        super.editOccured(e);
        boolean nok = true;
        String stringValue = this.text.getText();
        if (!stringValue.isEmpty()) {
            try {
                short current = Short.parseShort(this.text.getText());
                nok = current < this.min || current > this.max;
                this.text.setForeground((Color)(nok ? ByteBlowerColor.red : null));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.setValueValid(!nok);
    }

    public Object doGetValue() {
        String valueString = (String)super.doGetValue();
        if (valueString == "") {
            return null;
        }
        try {
            return Short.valueOf(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void doSetValue(Object value) {
        if (value instanceof Short) {
            super.doSetValue((Object)((Short)value).toString());
        } else {
            LOGGER.warning("ERROR : Value is no Short!");
        }
    }
}

