/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.preferences;

import com.excentis.products.byteblower.gui.history.operations.status.StatusUpdater;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.model.control.BatchController;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import com.excentis.products.byteblower.utils.cloud.CloudStatusPoller;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "com.excentis.products.byteblower.gui.preferences";
    private static Activator plugin;

    public Activator() {
        plugin = this;
        String url = ByteBlowerPreferences.getExcentisCloudUrl();
        Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, "Using Cloud URL " + url));
        if (ByteBlowerPreferences.allowCloudFunctionality()) {
            CloudStatusPoller.initialize((String)url, (String)ByteBlowerPreferences.getApiKey());
            ScenarioController.allowCloudFunctionality();
            BatchController.allowCloudFunctionality();
            ProjectSwitchNotifier.getInstance().addOpenCloseListener(project -> StatusUpdater.getInstance().showCloudStatusOnScenariosAndBatches());
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (ByteBlowerPreferences.allowCloudFunctionality()) {
            CloudStatusPoller.getInstance().halt();
        }
        plugin = null;
        ByteBlowerPreferences.prefs.flush();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

