/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.PlatformUI;

public class WizardLauncher {
    private static ArrayList<WizardLauncher> wizards = new ArrayList();
    private final String name;
    private final Runnable starter;

    static {
        wizards.add(WizardLauncher.noneWizard());
    }

    private static WizardLauncher noneWizard() {
        return new WizardLauncher("None", new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private static WizardLauncher unknownWizard() {
        return new WizardLauncher("Unkown", new Runnable(){

            @Override
            public void run() {
                Logger.getGlobal().log(Level.WARNING, "Trying to launch an unknown wizard");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WizardLauncher getNamed(String name) {
        ArrayList<WizardLauncher> arrayList = wizards;
        synchronized (arrayList) {
            for (WizardLauncher wizard : wizards) {
                if (!name.equals(wizard.name)) continue;
                return wizard;
            }
            return WizardLauncher.unknownWizard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWizard(String name, Runnable starter) {
        WizardLauncher launcher = new WizardLauncher(name, starter);
        ArrayList<WizardLauncher> arrayList = wizards;
        synchronized (arrayList) {
            wizards.add(launcher);
        }
    }

    public static Collection<WizardLauncher> wizards() {
        return new ArrayList<WizardLauncher>(wizards);
    }

    private WizardLauncher(String name, Runnable starter) {
        this.name = name;
        this.starter = starter;
    }

    public String name() {
        return this.name;
    }

    public void launch() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(this.starter);
    }
}

