/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.refresher;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.refresher.ServerRepositoryFetch;
import com.excentis.products.byteblower.gui.update.Activator;
import com.excentis.products.byteblower.model.control.server.PhysicalConfigurationController;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalConfigurationReaderImpl;
import com.excentis.products.byteblower.server.model.PhysicalConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;

class PhysicalConfigResources {
    private static Resource resource;
    protected static PhysicalConfiguration physicalConfiguration;
    private static final String SERVERS_RESOURCE_URL = "servers.xml";
    private static final Object initializeLock;
    private static boolean isInitialized;
    private static ServerRepositoryFetch serverFetch;

    static {
        initializeLock = new Object();
        isInitialized = false;
        serverFetch = null;
        PhysicalConfigResources.initialize();
        assert (resource != null);
        assert (physicalConfiguration != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Object object = initializeLock;
        synchronized (object) {
            if (isInitialized) {
                return;
            }
            AdapterFactoryEditingDomain domain = ByteBlowerEditingDomainProvider.getEditingDomain();
            if (PhysicalConfigResources.isSaved()) {
                resource = PhysicalConfigResources.loadPhysicalConfiguration(domain);
            }
            if (resource == null) {
                resource = PhysicalConfigResources.createPhysicalConfiguration(domain);
            }
            EObject firstObject = (EObject)resource.getContents().get(0);
            physicalConfiguration = (PhysicalConfiguration)firstObject;
            PhysicalConfigurationReaderImpl.setPhysicalConfiguration((PhysicalConfiguration)physicalConfiguration);
            if (Activator.isAutoUpdate()) {
                serverFetch = new ServerRepositoryFetch(physicalConfiguration);
                serverFetch.schedule();
            }
            isInitialized = true;
        }
    }

    public static void close() throws InterruptedException, IOException {
        HashMap saveOptions = new HashMap();
        resource.save(saveOptions);
        if (serverFetch != null) {
            serverFetch.cancel();
            serverFetch.join();
            serverFetch = null;
        }
    }

    private static URI getServerUri() {
        String workspace = ByteBlowerPreferences.getRuntimeWorkspaceLocation();
        Path path = new Path(workspace);
        path = path.append(SERVERS_RESOURCE_URL);
        String osPath = path.toOSString();
        return URI.createFileURI((String)osPath);
    }

    private static String getServerUrl() {
        URI uri = PhysicalConfigResources.getServerUri();
        return uri.toString();
    }

    private static boolean isSaved() {
        URI uri = PhysicalConfigResources.getServerUri();
        String fileName = uri.toFileString();
        File serverXml = new File(fileName);
        return serverXml.exists();
    }

    private static Resource loadPhysicalConfiguration(AdapterFactoryEditingDomain domain) {
        String url = PhysicalConfigResources.getServerUrl();
        return domain.loadResource(url);
    }

    private static Resource createPhysicalConfiguration(AdapterFactoryEditingDomain domain) {
        String url = PhysicalConfigResources.getServerUrl();
        Resource newResource = domain.createResource(url);
        try {
            newResource.load(null);
        }
        catch (IOException iOException) {
            String infoStatement = String.format("Newly created resource -  %s file does not exist yet", SERVERS_RESOURCE_URL);
            PhysicalConfigurationManager.LOGGER.log(Level.INFO, infoStatement);
        }
        physicalConfiguration = PhysicalConfigurationController.create();
        newResource.getContents().add((Object)physicalConfiguration);
        return newResource;
    }

    private PhysicalConfigResources() {
    }
}

