/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.report.viewer;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.enums.ReportFileFormat;
import com.excentis.products.byteblower.utils.Utils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ReportViewer {
    private static Logger LOGGER = Logger.getGlobal();
    private static ReportViewer instance;

    public static ReportViewer getInstance() {
        if (instance == null) {
            instance = new ReportViewer();
        }
        return instance;
    }

    public boolean openReport(Report report) {
        if (report == null) {
            return false;
        }
        return this.openReport(report.getFileUrl());
    }

    public boolean openReport(String fileUrl) {
        if (fileUrl == null) {
            return false;
        }
        if (fileUrl.startsWith("https://") || fileUrl.startsWith("http://")) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(fileUrl));
                return true;
            }
            catch (PartInitException e) {
                LOGGER.log(Level.SEVERE, "Unable to open report");
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "'{0}', Not real Web link to open ", fileUrl);
            }
        }
        try {
            File reportFile = new File(fileUrl);
            if (reportFile.exists() && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(reportFile);
                return true;
            }
        }
        catch (IOException e) {
            System.out.println("GeneratedReportsComposite::openReport : " + e);
            e.printStackTrace();
        }
        return false;
    }

    public String getFileFormatString(ReportFileFormat reportFileFormat) {
        if (reportFileFormat == null) {
            return "unknown";
        }
        return reportFileFormat.toString();
    }

    public String getFilenameWithoutPath(Report report) {
        Path file = new Path(report.getFileUrl());
        return file.lastSegment();
    }

    public boolean reportFileExists(Report report) {
        File file = new File(report.getFileUrl());
        return file.exists();
    }

    public boolean backupAvailable(TestDataReference testDataReference) {
        Date scenarioStartTime = testDataReference.getStartTime();
        String backupFilename = Utils.getBackupFilename((Date)scenarioStartTime);
        String archiveLocation = ByteBlowerPreferences.getArchiveLocation();
        Path path = new Path(archiveLocation);
        path = path.append(backupFilename);
        path = path.addFileExtension("zip");
        return path.toFile().exists();
    }

    public static void openRecentHtmlReport(TestDataReference ref) {
        List reportGenerations = ref.getReportGenerations();
        if (!reportGenerations.isEmpty()) {
            int size = reportGenerations.size();
            int index = size - 1;
            while (index >= 0) {
                ReportGeneration mostRecent = (ReportGeneration)reportGenerations.get(index);
                for (Report report : mostRecent.getReports()) {
                    if (report.getFileFormat() != ReportFileFormat.HTML || !ReportViewer.getInstance().openReport(report)) continue;
                    return;
                }
                --index;
            }
            MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            mb.setMessage("No HTML report present. Cannot open it.");
            mb.open();
        }
    }
}

