/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.runner;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceController;
import com.excentis.products.byteblower.results.dataprovider.data.TestDataReferenceManager;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.runner.jobs.ExecuteScenarioJob;
import com.excentis.products.byteblower.utils.Utils;
import com.excentis.products.byteblower.utils.zip.Zipper;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

final class BackupGeneration
extends JobChangeAdapter {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final int POLL_TIME = 150;
    private AtomicBoolean hasBackup = new AtomicBoolean(false);
    private final ExecuteScenarioJob scenarioJob;
    private final BackupPoller poller;

    BackupGeneration(ExecuteScenarioJob scenarioJob) {
        this.scenarioJob = scenarioJob;
        this.poller = new BackupPoller(scenarioJob);
    }

    public void running(IJobChangeEvent event) {
        this.poller.schedule();
    }

    public void done(IJobChangeEvent event) {
        this.poller.run(null);
        this.hasBackup.set(true);
    }

    private void earlyCleanup() {
        this.scenarioJob.removeJobChangeListener((IJobChangeListener)this);
    }

    private boolean saveZippedCopy(ByteBlowerProject project, String filename, String outputLocation) {
        boolean success = false;
        Path location = new Path(outputLocation);
        location = location.append(filename);
        IPath bbpLocation = location.addFileExtension("bbp");
        IPath zipLocation = location.addFileExtension("zip");
        XMIResourceImpl res = new XMIResourceImpl(URI.createFileURI((String)bbpLocation.toOSString()));
        ByteBlowerProject projectCopy = null;
        projectCopy = (ByteBlowerProject)EByteBlowercoreUtil.copy((EObject)project);
        res.getContents().add((Object)projectCopy);
        try {
            try {
                res.save(Collections.emptyMap());
                success = Zipper.zip((String)bbpLocation.toOSString(), (String)zipLocation.toOSString());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not save project backup", e);
                bbpLocation.toFile().delete();
            }
        }
        finally {
            bbpLocation.toFile().delete();
        }
        return success;
    }

    private void generateBackup(Long persistenceId, ExecuteScenarioJob scenarioJob) {
        ByteBlowerProject project = scenarioJob.getRunningModelProject();
        if (project.isReportProjectBackup()) {
            MetaDataPersistenceController controller = MetaDataPersistenceController.getInstance();
            TestDataReferenceManager manager = new TestDataReferenceManager(controller);
            Date scenarioStartTime = ((TestDataReference)manager.getEntity(persistenceId)).getStartTime();
            if (scenarioStartTime == null) {
                scenarioStartTime = new Date();
            }
            String backupFilename = Utils.getBackupFilename((Date)scenarioStartTime);
            this.saveZippedCopy(project, backupFilename, ByteBlowerPreferences.getArchiveLocation());
        }
    }

    private class BackupPoller
    extends Job {
        public BackupPoller(ExecuteScenarioJob scenarioJob) {
            super("Eager backup generation");
            this.setSystem(true);
            this.setPriority(50);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Long persistenceId = BackupGeneration.this.scenarioJob.getTestDataPersistenceId();
            if (persistenceId != null && BackupGeneration.this.hasBackup.compareAndSet(false, true)) {
                BackupGeneration.this.generateBackup(persistenceId, BackupGeneration.this.scenarioJob);
            }
            if (!BackupGeneration.this.hasBackup.get()) {
                this.schedule(150L);
            } else {
                BackupGeneration.this.earlyCleanup();
            }
            return Status.OK_STATUS;
        }
    }
}

