/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.actions.project;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerProjectAction;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class ByteBlowerPasteAction<TableObjectClass>
extends ByteBlowerProjectAction<TableObjectClass>
implements IAfterOperationListener {
    private int clipboardSize;

    public ByteBlowerPasteAction(String text, ByteBlowerViewerComposite<TableObjectClass> composite) {
        super(text, composite);
        this.single = text;
        this.multiple = String.valueOf(text) + "s";
    }

    public ByteBlowerPasteAction(String text, String textMultiple, ByteBlowerViewerComposite<TableObjectClass> composite) {
        super(text, composite);
        this.single = text;
        this.multiple = textMultiple;
    }

    private void runPasteOperation(Command command) {
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), this.getOperationText(), command);
        operation.run();
    }

    private void setClipboardSize(int length) {
        this.clipboardSize = length;
    }

    @Override
    protected String getOperationObjectsText() {
        boolean multi = this.clipboardSize > 1;
        return multi ? this.multiple : this.getText();
    }

    private String getOperationText() {
        return "Paste " + this.getOperationObjectsText();
    }

    protected int getPastePos() {
        int pastePos = -1;
        Object firstSelectedObject = this.composite.getFirstSelectedObject();
        if (firstSelectedObject != null && firstSelectedObject instanceof EByteBlowerObject) {
            EByteBlowerObject first = (EByteBlowerObject)firstSelectedObject;
            EByteBlowerObjectReader reader = ReaderFactory.create((EByteBlowerObject)first);
            pastePos = reader.getIndexInContainer() + 1;
        }
        return pastePos;
    }

    public void afterOperation(UndoableByteBlowerOperation operation) {
    }

    public void run() {
        StructuredViewer viewer = this.composite.getStructuredViewer();
        ColumnViewer view = (ColumnViewer)viewer;
        if (view.isCellEditorActive()) {
            CellEditor[] tt = view.getCellEditors();
            int i = 0;
            while (i < tt.length) {
                CellEditor cellEditor = tt[i];
                if (cellEditor.isActivated() && cellEditor.isPasteEnabled()) {
                    cellEditor.performPaste();
                }
                ++i;
            }
        } else {
            TableObjectClass[] copiedObjects = this.getClipboardObjects();
            if (copiedObjects == null) {
                this.setClipboardSize(0);
                this.setEnabled(false);
                return;
            }
            this.setClipboardSize(copiedObjects.length);
            if (copiedObjects.length == 0) {
                this.setEnabled(false);
                return;
            }
            this.runPasteOperation(this.getPasteCommand(copiedObjects));
        }
    }

    protected abstract Command getPasteCommand(TableObjectClass[] var1);

    protected abstract TableObjectClass[] getClipboardObjects();

    public void update() {
        TableObjectClass[] clipboardObjects = this.getClipboardObjects();
        boolean enable = clipboardObjects != null && clipboardObjects.length > 0;
        this.setEnabled(enable);
    }
}

