/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.sash;

import com.excentis.products.byteblower.gui.swt.composites.sash.ByteBlowerSashForm;
import com.excentis.products.byteblower.gui.swt.composites.sash.ByteBlowerSashFormData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

class ByteBlowerSashFormLayout
extends Layout {
    ByteBlowerSashFormLayout() {
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        ByteBlowerSashForm ByteBlowerSashForm2 = (ByteBlowerSashForm)composite;
        Control[] cArray = ByteBlowerSashForm2.getControls(true);
        int width = 0;
        int height = 0;
        if (cArray.length == 0) {
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
        boolean vertical = ByteBlowerSashForm2.getOrientation() == 512;
        int maxIndex = 0;
        int maxValue = 0;
        int i = 0;
        while (i < cArray.length) {
            Point size;
            if (vertical) {
                size = cArray[i].computeSize(wHint, -1, flushCache);
                if (size.y > maxValue) {
                    maxIndex = i;
                    maxValue = size.y;
                }
                width = Math.max(width, size.x);
            } else {
                size = cArray[i].computeSize(-1, hHint, flushCache);
                if (size.x > maxValue) {
                    maxIndex = i;
                    maxValue = size.x;
                }
                height = Math.max(height, size.y);
            }
            ++i;
        }
        long[] ratios = new long[cArray.length];
        long total = 0L;
        int i2 = 0;
        while (i2 < cArray.length) {
            Object data = cArray[i2].getLayoutData();
            if (data != null && data instanceof ByteBlowerSashFormData) {
                ratios[i2] = ((ByteBlowerSashFormData)data).weight;
            } else {
                data = new ByteBlowerSashFormData();
                cArray[i2].setLayoutData(data);
                ratios[i2] = 13108L;
                ((ByteBlowerSashFormData)data).weight = 13108L;
            }
            total += ratios[i2];
            ++i2;
        }
        if (ratios[maxIndex] > 0L) {
            int sashwidth;
            int n = sashwidth = ByteBlowerSashForm2.sashes.length > 0 ? ByteBlowerSashForm2.SASH_WIDTH + ByteBlowerSashForm2.sashes[0].getBorderWidth() * 2 : ByteBlowerSashForm2.SASH_WIDTH;
            if (vertical) {
                height += (int)(total * (long)maxValue / ratios[maxIndex]) + (cArray.length - 1) * sashwidth;
            } else {
                width += (int)(total * (long)maxValue / ratios[maxIndex]) + (cArray.length - 1) * sashwidth;
            }
        }
        width += ByteBlowerSashForm2.getBorderWidth() * 2;
        height += ByteBlowerSashForm2.getBorderWidth() * 2;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        int sashwidth;
        int i;
        Sash[] newSashes;
        ByteBlowerSashForm ByteBlowerSashForm2 = (ByteBlowerSashForm)composite;
        Rectangle area = ByteBlowerSashForm2.getClientArea();
        if (area.width <= 1 || area.height <= 1) {
            return;
        }
        Control[] newControls = ByteBlowerSashForm2.getControls(true);
        if (ByteBlowerSashForm2.controls.length == 0 && newControls.length == 0) {
            return;
        }
        Control[] controls = ByteBlowerSashForm2.controls = newControls;
        if (ByteBlowerSashForm2.maxControl != null && !ByteBlowerSashForm2.maxControl.isDisposed()) {
            int i2 = 0;
            while (i2 < controls.length) {
                if (controls[i2] != ByteBlowerSashForm2.maxControl) {
                    controls[i2].setBounds(-200, -200, 0, 0);
                } else {
                    controls[i2].setBounds(area);
                }
                ++i2;
            }
            return;
        }
        if (ByteBlowerSashForm2.sashes.length < controls.length - 1) {
            newSashes = new Sash[controls.length - 1];
            System.arraycopy(ByteBlowerSashForm2.sashes, 0, newSashes, 0, ByteBlowerSashForm2.sashes.length);
            i = ByteBlowerSashForm2.sashes.length;
            while (i < newSashes.length) {
                newSashes[i] = ByteBlowerSashForm2.createSash();
                ++i;
            }
            ByteBlowerSashForm2.sashes = newSashes;
        }
        if (ByteBlowerSashForm2.sashes.length > controls.length - 1) {
            if (controls.length == 0) {
                int i3 = 0;
                while (i3 < ByteBlowerSashForm2.sashes.length) {
                    ByteBlowerSashForm2.sashes[i3].dispose();
                    ++i3;
                }
                ByteBlowerSashForm2.sashes = new Sash[0];
            } else {
                newSashes = new Sash[controls.length - 1];
                System.arraycopy(ByteBlowerSashForm2.sashes, 0, newSashes, 0, newSashes.length);
                i = controls.length - 1;
                while (i < ByteBlowerSashForm2.sashes.length) {
                    ByteBlowerSashForm2.sashes[i].dispose();
                    ++i;
                }
                ByteBlowerSashForm2.sashes = newSashes;
            }
        }
        if (controls.length == 0) {
            return;
        }
        Sash[] sashes = ByteBlowerSashForm2.sashes;
        long[] ratios = new long[controls.length];
        long total = 0L;
        int i4 = 0;
        while (i4 < controls.length) {
            Object data = controls[i4].getLayoutData();
            if (data != null && data instanceof ByteBlowerSashFormData) {
                ratios[i4] = ((ByteBlowerSashFormData)data).weight;
            } else {
                data = new ByteBlowerSashFormData();
                controls[i4].setLayoutData(data);
                ratios[i4] = 13108L;
                ((ByteBlowerSashFormData)data).weight = 13108L;
            }
            total += ratios[i4];
            ++i4;
        }
        int n = sashwidth = sashes.length > 0 ? ByteBlowerSashForm2.SASH_WIDTH + sashes[0].getBorderWidth() * 2 : ByteBlowerSashForm2.SASH_WIDTH;
        if (ByteBlowerSashForm2.getOrientation() == 256) {
            int width = (int)(ratios[0] * (long)(area.width - sashes.length * sashwidth) / total);
            int x = area.x;
            controls[0].setBounds(x, area.y, width, area.height);
            x += width;
            int i5 = 1;
            while (i5 < controls.length - 1) {
                sashes[i5 - 1].setBounds(x, area.y, sashwidth, area.height);
                width = (int)(ratios[i5] * (long)(area.width - sashes.length * sashwidth) / total);
                controls[i5].setBounds(x += sashwidth, area.y, width, area.height);
                x += width;
                ++i5;
            }
            if (controls.length > 1) {
                sashes[sashes.length - 1].setBounds(x, area.y, sashwidth, area.height);
                width = area.width - (x += sashwidth);
                controls[controls.length - 1].setBounds(x, area.y, width, area.height);
            }
        } else {
            int height = (int)(ratios[0] * (long)(area.height - sashes.length * sashwidth) / total);
            int y = area.y;
            controls[0].setBounds(area.x, y, area.width, height);
            y += height;
            int i6 = 1;
            while (i6 < controls.length - 1) {
                sashes[i6 - 1].setBounds(area.x, y, area.width, sashwidth);
                height = (int)(ratios[i6] * (long)(area.height - sashes.length * sashwidth) / total);
                controls[i6].setBounds(area.x, y += sashwidth, area.width, height);
                y += height;
                ++i6;
            }
            if (controls.length > 1) {
                sashes[sashes.length - 1].setBounds(area.x, y, area.width, sashwidth);
                height = area.height - (y += sashwidth);
                controls[controls.length - 1].setBounds(area.x, y, area.width, height);
            }
        }
    }
}

