/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.swt.composites.server.IDocker;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class DockerComposite
extends ByteBlowerComposite
implements SelectionListener,
ControlListener {
    private IDocker docker;
    private ToolItem itemDock;
    private ToolItem itemUndock;
    private Image itemDockImage = null;
    private Image itemDockDisabledImage = null;
    private Image itemUndockImage = null;
    private Image itemUndockDisabledImage = null;

    public DockerComposite(Composite parent, IDocker docker) {
        super(parent);
        this.docker = docker;
        docker.setDockerComposite(this);
        this.addControlListener(this);
        this.initialize(parent);
        this.updateWidgets();
    }

    private void initialize(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        this.addDummyFillers();
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        this.setLayout((Layout)layout);
        ToolBar toolbar = new ToolBar((Composite)this, 512);
        toolbar.setLayoutData((Object)new GridData(0x1000000));
        ImageDescriptor imagedescr = null;
        this.itemDock = new ToolItem(toolbar, 0);
        imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"config/e_arrow_left.gif");
        this.itemDockImage = imagedescr.createImage();
        this.itemDock.setImage(this.itemDockImage);
        imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"config/d_arrow_left.gif");
        this.itemDockDisabledImage = imagedescr.createImage();
        this.itemDock.setDisabledImage(this.itemDockDisabledImage);
        this.itemDock.setToolTipText("Dock");
        this.itemDock.addSelectionListener((SelectionListener)this);
        this.itemUndock = new ToolItem(toolbar, 0);
        imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"config/e_arrow_right.gif");
        this.itemUndockImage = imagedescr.createImage();
        this.itemUndock.setImage(this.itemUndockImage);
        imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"config/d_arrow_right.gif");
        this.itemUndockDisabledImage = imagedescr.createImage();
        this.itemUndock.setDisabledImage(this.itemUndockDisabledImage);
        this.itemUndock.setToolTipText("Undock");
        this.itemUndock.addSelectionListener((SelectionListener)this);
    }

    private void addDummyFillers() {
        int i = 0;
        while (i < 2) {
            Button btn = new Button((Composite)this, 0);
            btn.setVisible(false);
            ++i;
        }
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.itemDock) {
            this.dock();
        } else if (source == this.itemUndock) {
            this.undock();
        }
    }

    private void dock() {
        this.docker.dock();
    }

    private void undock() {
        this.docker.undock();
    }

    @Override
    public void updateWidgets() {
        this.itemDock.setEnabled(this.docker.canDock());
        this.itemUndock.setEnabled(this.docker.canUndock());
    }

    @Override
    public StructuredViewer getParentViewer() {
        return null;
    }
}

