/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.swt.composites.server.GraphicPassPrompt;
import com.excentis.products.byteblower.gui.swt.composites.server.ServerComposite;
import com.excentis.products.byteblower.gui.utils.OSValidator;
import com.excentis.products.byteblower.utils.ssh.ByteBlowerSupportTool;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class SupportToolJob
extends Job {
    private static final Logger LOGGER = Logger.getGlobal();
    private static final boolean UPLOAD_SUPPORTED = false;
    private static final String UPLOAD_URL = "http://ubuntu-14-04-amd64-tp-dev-1.buildnet.excentis.com:7777/v1/";
    private final Shell shell;
    private final ByteBlowerSupportTool starter;
    private final String address;
    private final GraphicPassPrompt prompt;

    SupportToolJob(Shell shell, ByteBlowerSupportTool starter, String address, GraphicPassPrompt prompt) {
        super("Support tool on " + address);
        this.shell = shell;
        this.starter = starter;
        this.address = address;
        this.prompt = prompt;
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean successUpload = this.starter.gatherSupport();
        if (!successUpload && this.starter.hasArchiveFileLocation()) {
            File tmpLocation = null;
            try {
                try {
                    tmpLocation = this.starter.downloadSupportArchive();
                    successUpload = this.uploadToSupport(tmpLocation);
                    if (!successUpload) {
                        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SaveArchive(tmpLocation));
                    }
                }
                catch (Exception e) {
                    this.prompt.askClose();
                    ServerComposite.LOGGER.log(Level.WARNING, "Failed to fetch support archive", e);
                    if (tmpLocation != null) {
                        tmpLocation.delete();
                    }
                }
            }
            finally {
                if (tmpLocation != null) {
                    tmpLocation.delete();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private boolean uploadToSupport(File tmpLocation) {
        boolean succeeded = false;
        return succeeded;
    }

    private final class SaveArchive
    implements Runnable {
        private final File tempLocation;

        private SaveArchive(File tmpLocation) {
            this.tempLocation = tmpLocation;
        }

        @Override
        public void run() {
            FileDialog storeLocation = new FileDialog(SupportToolJob.this.shell, 8192);
            String[] extensions = new String[]{"*.tar.bz2"};
            storeLocation.setFilterExtensions(extensions);
            if (OSValidator.isWindows()) {
                storeLocation.setFileName("support_archive");
            } else {
                storeLocation.setFileName("support_archive.tar.bz2");
            }
            storeLocation.setFilterPath(ByteBlowerPreferences.getArchiveLocation());
            storeLocation.setText("Where do you want to store the support archive?");
            String target = storeLocation.open();
            if (target != null) {
                ServerComposite.LOGGER.info("Moving support archive to " + target);
                try {
                    Files.move(this.tempLocation.toPath(), Paths.get(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    ServerComposite.LOGGER.log(Level.WARNING, "Could not move file to final location", e);
                }
            }
            SupportToolJob.this.prompt.askClose();
        }
    }
}

