/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.composites.server.actions;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.swt.composites.server.IDockListener;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.PhysicalDockableController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;

public class DockAction
extends Action
implements IAfterOperationListener {
    private EList<ByteBlowerGuiPortReader> ports;
    private EList<PhysicalDockable> dockables;
    private List<IDockListener> dockListeners = new ArrayList<IDockListener>();

    public DockAction() {
        super("Dock");
        this.update();
    }

    public void setSelectedByteBlowerGuiPorts(EList<ByteBlowerGuiPortReader> selectedPorts) {
        this.ports = selectedPorts;
        this.update();
    }

    public void setSelectedDockables(EList<PhysicalDockable> dockables) {
        this.dockables = dockables;
        this.update();
    }

    private boolean canDock() {
        boolean hasDockables;
        boolean hasPorts = this.ports != null && !this.ports.isEmpty();
        boolean bl = hasDockables = this.dockables != null && !this.dockables.isEmpty();
        if (hasPorts && hasDockables) {
            PhysicalConfigurationManager manager = this.getPhysicalConfigurationManager();
            if (manager.isAlreadyDocked(this.ports, this.dockables)) {
                return false;
            }
            return manager.hasDockingRoom(this.ports.size(), this.dockables);
        }
        return false;
    }

    private void update() {
        boolean enable = this.canDock();
        this.setEnabled(enable);
    }

    public void run() {
        Iterator dockableIt = this.dockables.iterator();
        if (!dockableIt.hasNext() || this.ports.isEmpty()) {
            return;
        }
        boolean multiplePorts = this.ports.size() > 1;
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), multiplePorts ? "Dock Ports" : "Dock Port");
        for (ByteBlowerGuiPortReader bbPort : this.ports) {
            PhysicalConfigurationReader reader;
            PhysicalDockable oldDockable;
            if (!dockableIt.hasNext()) {
                dockableIt = this.dockables.iterator();
            }
            PhysicalDockable dockable = (PhysicalDockable)dockableIt.next();
            ByteBlowerGuiPortConfiguration portConfig = bbPort.getByteBlowerGuiPortConfiguration();
            ByteBlowerGuiPortConfigurationController configController = ControllerFactory.create((ByteBlowerGuiPortConfiguration)portConfig);
            PhysicalDockable currentDockable = this.getPhysicalConfigurationReader().getPhysicalDockable((ByteBlowerGuiPortConfigurationReader)configController);
            if (currentDockable == dockable) continue;
            if (configController.isDocked() && (oldDockable = (reader = this.getPhysicalConfigurationReader()).getPhysicalDockable((ByteBlowerGuiPortConfigurationReader)configController)) != null) {
                operation.appendCommand(this.undock(configController, oldDockable));
            }
            operation.appendCommand(configController.dock(dockable));
            PhysicalDockableController dockableController = ControllerFactory.create((PhysicalDockable)dockable);
            operation.appendCommand(dockableController.dock(portConfig));
        }
        operation.addAfterOperationListener((IAfterOperationListener)this);
        operation.run();
    }

    private PhysicalConfigurationManager getPhysicalConfigurationManager() {
        return PhysicalConfigurationManager.getInstance();
    }

    private PhysicalConfigurationReader getPhysicalConfigurationReader() {
        return this.getPhysicalConfigurationManager().getPhysicalConfigurationReader();
    }

    private Command undock(ByteBlowerGuiPortConfigurationController configController, PhysicalDockable oldDockable) {
        PhysicalDockableController dockableController = ControllerFactory.create((PhysicalDockable)oldDockable);
        ByteBlowerGuiPortConfiguration portConfig = (ByteBlowerGuiPortConfiguration)configController.getObject();
        return dockableController.undock(portConfig);
    }

    public void addDockListener(IDockListener dockListener) {
        if (!this.dockListeners.contains(dockListener)) {
            this.dockListeners.add(dockListener);
        }
    }

    public void afterOperation(UndoableByteBlowerOperation operation) {
        this.notifyDockListeners();
    }

    private void notifyDockListeners() {
        for (IDockListener listener : this.dockListeners) {
            listener.docked(this.ports, this.dockables);
        }
    }

    public void link() {
        if (this.ports == null) {
            return;
        }
        for (IDockListener listener : this.dockListeners) {
            listener.link(this.ports);
        }
    }
}

