/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.contentprovider;

import com.excentis.products.byteblower.gui.swt.contentprovider.LazyContentProvider;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerViewer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ByteBlowerGuiModelContentProvider
extends LazyContentProvider {
    protected Class<?> parentClass;
    private Class<?> viewedClass;
    protected int featureId;

    public ByteBlowerGuiModelContentProvider(ComposedAdapterFactory adapterFactory, IByteBlowerViewer byteblowerViewer, Class<?> viewedClass, Class<?> parentClass, int featureId) {
        super((AdapterFactory)adapterFactory, byteblowerViewer);
        this.parentClass = parentClass;
        this.viewedClass = viewedClass;
        this.featureId = featureId;
    }

    protected EObject getViewedObject(EObject notifier) {
        while (notifier != null) {
            if (this.viewedClass.isInstance(notifier)) {
                return notifier;
            }
            notifier = notifier.eContainer();
        }
        return null;
    }

    @Override
    protected BasicEList<EObject> getLazyElements(Object object) {
        this.testLog("LazyContentProvider::getLazyElements " + object);
        EObject parentObject = (EObject)object;
        EClass parentEClass = parentObject.eClass();
        BasicEList eList = new BasicEList();
        EStructuralFeature feature = parentEClass.getEStructuralFeature(this.featureId);
        Object elements = parentObject.eGet(feature);
        if (elements != null) {
            try {
                for (EObject objecto : (BasicEList)elements) {
                    eList.add((Object)objecto);
                }
            }
            catch (ClassCastException classCastException) {
                this.testLog("LazyContentProvider::getElements ClassCastException - Should never happen ! " + classCastException);
            }
        }
        return eList;
    }

    public void notifyChanged(Notification notification) {
        if (!(notification instanceof ViewerNotification)) {
            this.testLog("LazyContentProvider::notifyChanged IGNORED : no ViewerNotification");
            return;
        }
        ViewerNotification viewerNotification = (ViewerNotification)notification;
        Object object = viewerNotification.getElement();
        if (!(object instanceof EObject)) {
            this.testLog("LazyContentProvider::notifyChanged IGNORED : no EObject");
            return;
        }
        EObject notifier = (EObject)object;
        int notificationFeatureId = notification.getFeatureID(this.parentClass);
        if (this.parentClass != null && this.parentClass.isInstance(notifier) && this.featureId == notificationFeatureId) {
            this.testLog("LazyContentProvider::notifyChanged => START MINIMIZER");
            this.doFullRefresh();
        } else {
            if (notificationFeatureId != 1 || notification.getNewValue() != Boolean.TRUE) {
                return;
            }
            if (this.isSorted()) {
                this.doFullRefresh();
            } else {
                EObject viewedObject = this.getViewedObject(notifier);
                if (this.content != null && viewedObject != null) {
                    int currentlyDisplayed = this.content.length;
                    int i = 0;
                    while (i < currentlyDisplayed) {
                        try {
                            EObject itemObject = (EObject)this.content[i];
                            itemObject = this.getViewedObject(itemObject);
                            if (itemObject == viewedObject) {
                                this.updateRowIndex(i);
                                return;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.out.println("LazyContentProvider::notifyChanged : ArrayIndexOutOfBoundsException");
                        }
                        ++i;
                    }
                }
            }
        }
    }
}

