/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.dialogs;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.swt.dialogs.FilterVerify;
import java.util.function.Consumer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

class BPFTextFeedback
implements VerifyListener {
    private final FilterVerify verify;
    private final Text txtFilter;

    public BPFTextFeedback(Text toCheck, String bbServerAddress) {
        this.verify = new FilterVerify(bbServerAddress);
        this.txtFilter = toCheck;
    }

    public void verifyText(VerifyEvent e) {
        Text t = (Text)e.widget;
        String previous = t.getText();
        final String totalFilter = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
        this.txtFilter.setForeground(null);
        this.verify.isValidFilter(totalFilter, new Consumer<Boolean>(){

            @Override
            public void accept(Boolean isGood) {
                Display disp = Display.getDefault();
                if (disp == null || disp.isDisposed()) {
                    return;
                }
                disp.asyncExec((Runnable)new ApplyColor(totalFilter, isGood, BPFTextFeedback.this.txtFilter));
            }
        });
    }

    private static final class ApplyColor
    implements Runnable {
        private static final Color BAD_COLOR = ExcentisColors.red;
        private static final Color DEFAULT_COLOR = null;
        private final String expectedText;
        private final Color expectedColor;
        private final Text txtFilter;

        private ApplyColor(String expectedText, boolean isGood, Text txt) {
            this.expectedText = expectedText;
            this.expectedColor = isGood ? DEFAULT_COLOR : BAD_COLOR;
            this.txtFilter = txt;
        }

        @Override
        public void run() {
            String currentTxt;
            if (!this.txtFilter.isDisposed() && (currentTxt = this.txtFilter.getText()).equals(this.expectedText)) {
                this.txtFilter.setForeground(this.expectedColor);
            }
        }
    }
}

