/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.dnd;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerMoveOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.transfer.ByteBlowerTransfer;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ByteBlowerDropAdapter
extends ViewerDropAdapter {
    private static Logger LOGGER = Logger.getGlobal();
    protected EObject dropParent;
    protected int dropIndex;
    protected Class<?> dropClass;

    public ByteBlowerDropAdapter(Viewer viewer, Class<?> dropClass) {
        super(viewer);
        this.dropClass = dropClass;
    }

    public void dragOver(DropTargetEvent event) {
        TableItem item;
        Widget widget = event.item;
        Object itemData = null;
        if (widget instanceof TableItem) {
            item = (TableItem)widget;
            if (item != null) {
                itemData = item.getData();
            }
        } else if (widget instanceof TreeItem && (item = (TreeItem)widget) != null) {
            itemData = item.getData();
        }
        if (itemData != null && this.dropClass.isInstance(itemData)) {
            EByteBlowerObject object = (EByteBlowerObject)itemData;
            this.dropIndex = ReaderFactory.getIndexInContainer((EByteBlowerObject)object);
            this.dropParent = object.eContainer();
        }
        super.dragOver(event);
    }

    public boolean performDrop(Object data) {
        StructuredSelection selection = (StructuredSelection)data;
        EByteBlowerObject eByteBlowerObject = null;
        int localDropIndex = this.dropIndex;
        UniqueEList list = new UniqueEList();
        try {
            for (Object draggedObject : selection) {
                if (this.dropClass.isInstance(draggedObject)) {
                    eByteBlowerObject = (EByteBlowerObject)draggedObject;
                }
                list.add((Object)eByteBlowerObject);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Can't do drop part of the 'drag and drop'", e);
            localDropIndex = 0;
        }
        if (eByteBlowerObject == null) {
            return false;
        }
        EReference feature = eByteBlowerObject.eContainmentFeature();
        if (feature == null || ByteBlowerGuiResourceController.getProject() == null) {
            LOGGER.warning("Invalid reference for the drop part of the 'drag and drop'");
            return false;
        }
        ByteBlowerMoveOperation operation = new ByteBlowerMoveOperation(ByteBlowerGuiResourceController.getProject(), "Move Operation", this.getDropParent(), feature, (EList)list, localDropIndex);
        operation.run();
        return true;
    }

    protected EObject getDropParent() {
        return this.dropParent;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return ByteBlowerTransfer.getInstance(this.dropClass).isSupportedType(transferType);
    }
}

