/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerProjectReaderImpl;
import com.excentis.products.byteblower.model.util.IOpenCloseListener;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ByteBlowerComposite
extends Composite
implements IByteBlowerComposite,
FocusListener {
    private IByteBlowerComposite parentComposite;
    private ByteBlowerProject currentProject;
    private ByteBlowerProjectReader projectReader;
    private List<Control> controls = new ArrayList<Control>();
    private static Clipboard clipboard;

    public void widgetDisposed(DisposeEvent e) {
        ProjectSwitchNotifier.getInstance().removeOpenCloseListener((IOpenCloseListener)this);
    }

    protected ByteBlowerComposite(Composite parent) {
        this(parent, null);
    }

    public ByteBlowerComposite(Composite parent, int style) {
        this(parent, null, style);
    }

    protected ByteBlowerComposite(Composite parent, IByteBlowerComposite parentComposite) {
        this(parent, parentComposite, 0);
    }

    private ByteBlowerComposite(Composite parent, IByteBlowerComposite parentComposite, int style) {
        super(parent, style);
        this.parentComposite = parentComposite;
        if (parentComposite instanceof IByteBlowerViewerComposite) {
            IByteBlowerViewerComposite parentViewerComposite = (IByteBlowerViewerComposite)parentComposite;
            parentViewerComposite.addSelectionListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ByteBlowerComposite.this.parentSelectionChanged(event);
                }
            });
        }
        ByteBlowerProject currentProject = this.getActiveProject();
        this.setCurrentProject(currentProject);
        ProjectSwitchNotifier.getInstance().addOpenCloseListener((IOpenCloseListener)this);
        this.addDisposeListener((DisposeListener)this);
    }

    public Composite getComposite() {
        return this;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
    }

    private ByteBlowerProject getActiveProject() {
        return this.getResourceController().getActiveProject();
    }

    private ByteBlowerGuiResourceController getResourceController() {
        return ByteBlowerGuiResourceController.getInstance();
    }

    public abstract void updateWidgets();

    protected void projectChanged(ByteBlowerProject project) {
    }

    public void projectOpenedOrClosed(ByteBlowerProject project) {
        this.setCurrentProject(project);
        this.projectChanged(project);
        this.updateWidgets();
    }

    private void setCurrentProject(ByteBlowerProject project) {
        this.currentProject = project;
        this.projectReader = project != null ? new ByteBlowerProjectReaderImpl(project) : null;
    }

    protected ByteBlowerProject getProject() {
        return this.currentProject;
    }

    protected ByteBlowerProjectReader getProjectReader() {
        return this.projectReader;
    }

    protected void registerControl(Control widget) {
        this.controls.add(widget);
        widget.addFocusListener((FocusListener)this);
    }

    protected List<Control> getControls() {
        return this.controls;
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public Clipboard getClipboard() {
        if (clipboard == null) {
            clipboard = new Clipboard(this.getDisplay());
        }
        return clipboard;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
    }

    public StructuredViewer getParentViewer() {
        if (this.parentComposite instanceof IByteBlowerViewerComposite) {
            IByteBlowerViewerComposite parentViewerComposite = (IByteBlowerViewerComposite)this.parentComposite;
            return parentViewerComposite.getStructuredViewer();
        }
        return null;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(runnable);
    }
}

