/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.table;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerBasicTableViewer;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTableViewer;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerTableComposite;
import java.util.Arrays;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public abstract class ByteBlowerBasicTableComposite<TableObjectClass>
extends ByteBlowerViewerComposite<TableObjectClass>
implements IByteBlowerTableComposite,
ControlListener {
    private Label lblTable;
    private ITableLabelProvider labelProvider;
    private ByteBlowerPopupMenu popupMenu;
    private int nofTopWidgets;
    protected IByteBlowerAction actionInterface;
    private CellEditor[] editors;

    protected int getNofTopWidgets() {
        return this.nofTopWidgets;
    }

    public ByteBlowerBasicTableComposite(Composite parent, String identifier, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher, ITableLabelProvider labelProvider) {
        this(parent, identifier, actionInterface, focusDispatcher, labelProvider, null);
    }

    public ByteBlowerBasicTableComposite(Composite parent, String identifier, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher, ITableLabelProvider labelProvider, ByteBlowerBasicTableComposite<?> parentComposite) {
        super(parent, identifier, focusDispatcher, parentComposite);
        this.actionInterface = actionInterface;
        this.labelProvider = labelProvider;
        this.initialize();
    }

    public ByteBlowerTableViewer getTableViewer() {
        return (ByteBlowerTableViewer)this.columnViewer;
    }

    protected Label getLabel() {
        return this.lblTable;
    }

    protected abstract void initializeChildClass();

    private void initialize() {
        this.createBasicWidgets();
        this.initializeLayout();
        this.initializeListeners();
        this.initializeCellModifiers();
        this.initializeCellEditors();
        this.initializePopupMenu();
        this.initializeActionListeners();
        this.initializeInput();
        this.updateWidgets();
        ByteBlowerComparator comparator = this.getTableViewer().getViewerComparator();
        this.getTableViewer().setComparator(comparator);
        this.afterInitialization();
    }

    protected void initializeActionListeners() {
    }

    protected void afterInitialization() {
    }

    private void initializeInput() {
        Object initialInput = this.getInitialInput();
        if (initialInput != null) {
            this.setInput(initialInput);
        }
    }

    protected TableViewer createTableViewer() {
        String[] columnNames = this.getColumnNames();
        int[] columnWeights = this.getColumnWeights();
        ByteBlowerBasicTableViewer viewer = new ByteBlowerBasicTableViewer(this, columnNames, columnWeights, this.labelProvider);
        return viewer;
    }

    private void initializeCellModifiers() {
        ICellModifier cellModifier = this.getCellModifier();
        this.columnViewer.setCellModifier(cellModifier);
    }

    protected abstract String getTableLabel();

    protected abstract CellEditor[] createCellEditors();

    protected CellEditor[] getCellEditors() {
        if (this.editors == null) {
            this.editors = this.createCellEditors();
        }
        return this.editors;
    }

    private void initializeCellEditors() {
        this.editors = this.getCellEditors();
        this.columnViewer.setCellEditors(this.editors);
    }

    protected abstract ICellModifier getCellModifier();

    private void createBasicWidgets() {
        this.lblTable = new Label((Composite)this, 0);
        this.registerControl((Control)this.lblTable);
        this.nofTopWidgets = 1;
        this.nofTopWidgets += this.createTopWidgets();
        TableViewer tableViewer = this.createTableViewer();
        this.setColumnViewer((ColumnViewer)tableViewer);
        this.registerControl(tableViewer.getControl());
        String label = this.getTableLabel();
        this.lblTable.setText(label);
    }

    protected abstract int createTopWidgets();

    private void initializeListeners() {
        this.initializeBasicChildListeners();
        this.addControlListener(this);
    }

    protected abstract void initializeBasicChildListeners();

    private void initializeLayout() {
        GridLayout layout = new GridLayout(this.nofTopWidgets, false);
        this.setLayout((Layout)layout);
        GridData labelLayoutData = new GridData(768);
        this.lblTable.setLayoutData((Object)labelLayoutData);
        Table table = this.getTable();
        GridData tableLayoutData = new GridData(1808);
        tableLayoutData.horizontalSpan = this.nofTopWidgets;
        table.setLayoutData((Object)tableLayoutData);
    }

    @Override
    public Table getTable() {
        return this.getTableViewer().getTable();
    }

    @Override
    public int getColumnIndex(String column) {
        return Arrays.asList(this.getColumnNames()).indexOf(column);
    }

    @Override
    public void controlMoved(ControlEvent arg0) {
    }

    @Override
    public void updateWidgets() {
        if (this.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ByteBlowerBasicTableComposite.this.lblTable.isDisposed()) {
                    return;
                }
                Object input = ByteBlowerBasicTableComposite.this.getInput();
                boolean enable = input != null;
                for (Control control : ByteBlowerBasicTableComposite.this.getControls()) {
                    control.setEnabled(enable);
                }
                ByteBlowerBasicTableComposite.this.updateCustomWidgets(enable);
                Table table = ByteBlowerBasicTableComposite.this.getTable();
                if (table.getEnabled() != enable) {
                    table.setEnabled(enable);
                    table.setHeaderVisible(enable);
                }
            }
        });
    }

    protected abstract void updateCustomWidgets(boolean var1);

    public void selectAndReveal(final TableObjectClass object) {
        final ByteBlowerTableViewer tableViewer = this.getTableViewer();
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                tableViewer.setSelection((ISelection)new StructuredSelection(object), true);
            }
        });
    }

    @Override
    public void controlResized(ControlEvent e) {
    }

    public StructuredViewer getStructuredViewer() {
        return this.columnViewer;
    }

    @Override
    public int getFirstSelectedIndex() {
        StructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return -1;
        }
        return this.getTable().getSelectionIndex();
    }

    @Override
    public void hardRefresh() {
        this.getStructuredViewer().refresh();
    }

    protected abstract ByteBlowerPopupMenu createPopupMenu();

    private void initializePopupMenu() {
        this.popupMenu = this.createPopupMenu();
        if (this.popupMenu != null) {
            this.getTable().setMenu(this.popupMenu.getMenu());
        }
    }

    protected void setLabelText(String string) {
        if (!this.isDisposed()) {
            this.lblTable.setText(string);
        }
    }

    protected void setLabelForeground(Color color) {
        if (!this.isDisposed()) {
            this.lblTable.setForeground(color);
        }
    }
}

