/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.text;

import java.util.regex.Pattern;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class Ipv4AddressAndMaskTextFactory {
    private static String IpAddressPartNonZero = "([1-9]|[1-9][0-9]|1[0-9]{2,2}|2[0-4][0-9]|25[0-5])";
    private static String IpAddressPart = "(\\d|[0-9]\\d|[0-1]\\d\\d|2[0-4]\\d|25[0-5])";
    private static String IpAddressPattern = "^(" + IpAddressPartNonZero + "(\\.(" + IpAddressPart + "(\\.(" + IpAddressPart + "(\\.(" + IpAddressPart + "(\\/(([0-9]|[0-2][0-9]|3[0-2])" + ")?)?)?)?)?)?)?)?)?$";
    private static String completeIpAddress = "^" + IpAddressPartNonZero + "\\." + IpAddressPart + "\\." + IpAddressPart + "\\." + IpAddressPart + "$";
    private static String completeIpAddressAndMask = "^" + IpAddressPart + "\\." + IpAddressPart + "\\." + IpAddressPart + "\\." + IpAddressPart + "\\/([0-9]|[0-2][0-9]|3[0-2])" + "$";
    private static Ipv4AddressAndMaskTextFactory instance = null;

    private Ipv4AddressAndMaskTextFactory() {
    }

    public static Ipv4AddressAndMaskTextFactory instance() {
        if (instance == null) {
            instance = new Ipv4AddressAndMaskTextFactory();
        }
        return instance;
    }

    public Text create(Composite parent, int style) {
        Text newItem = new Text(parent, style);
        newItem.setText("1.1.0.0");
        newItem.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                e.doit = Pattern.matches(IpAddressPattern, result);
            }
        });
        return newItem;
    }

    public boolean checkComplete(Text text) {
        return Pattern.matches(completeIpAddress, text.getText()) || Pattern.matches(completeIpAddressAndMask, text.getText());
    }

    public boolean hasMask(Text text) {
        return Pattern.matches(completeIpAddressAndMask, text.getText());
    }

    public String extractMask(Text text) {
        if (this.hasMask(text)) {
            int position = text.getText().lastIndexOf("/");
            int result = new Integer(text.getText().substring(position + 1));
            System.out.println("Result is " + result);
            String resultString = new String();
            int i = 0;
            while (i < 4) {
                switch (result) {
                    case 0: {
                        resultString = String.valueOf(resultString) + "0";
                        break;
                    }
                    case 1: {
                        resultString = String.valueOf(resultString) + "128";
                        break;
                    }
                    case 2: {
                        resultString = String.valueOf(resultString) + "192";
                        break;
                    }
                    case 3: {
                        resultString = String.valueOf(resultString) + "224";
                        break;
                    }
                    case 4: {
                        resultString = String.valueOf(resultString) + "240";
                        break;
                    }
                    case 5: {
                        resultString = String.valueOf(resultString) + "248";
                        break;
                    }
                    case 6: {
                        resultString = String.valueOf(resultString) + "252";
                        break;
                    }
                    case 7: {
                        resultString = String.valueOf(resultString) + "254";
                        break;
                    }
                    default: {
                        resultString = String.valueOf(resultString) + "255";
                    }
                }
                if (i != 3) {
                    resultString = String.valueOf(resultString) + ".";
                }
                result = result > 8 ? (result -= 8) : 0;
                ++i;
            }
            return resultString;
        }
        return new String();
    }

    public void setMask(Text text, String mask) {
        if (this.hasMask(text)) {
            String maskString = new String(mask);
            int result = 0;
            int i = 0;
            while (i < 4) {
                try {
                    int partValue = 0;
                    partValue = maskString.indexOf(".") > 0 ? new Integer(maskString.substring(0, maskString.indexOf("."))).intValue() : new Integer(maskString).intValue();
                    System.out.println("Partvalue is " + partValue);
                    if (partValue >= 255) {
                        result += 8;
                    } else if (partValue >= 254) {
                        result += 7;
                    } else if (partValue >= 252) {
                        result += 6;
                    } else if (partValue >= 248) {
                        result += 5;
                    } else if (partValue >= 240) {
                        result += 4;
                    } else if (partValue >= 224) {
                        result += 3;
                    } else if (partValue >= 192) {
                        result += 2;
                    } else if (partValue >= 128) {
                        ++result;
                    }
                    maskString = maskString.substring(maskString.indexOf(".") + 1);
                }
                catch (Exception exception) {
                    break;
                }
                System.out.println("Mask string is " + maskString);
                ++i;
            }
            System.out.println("Result is " + result);
            text.setText(String.valueOf(text.getText().substring(0, text.getText().lastIndexOf("/"))) + "/" + result);
        }
    }
}

