/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.text;

import com.excentis.products.byteblower.model.control.MacAddressController;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MacAddressTextFactory {
    private static MacAddressTextFactory instance = null;

    private MacAddressTextFactory() {
    }

    public static MacAddressTextFactory instance() {
        if (instance == null) {
            instance = new MacAddressTextFactory();
        }
        return instance;
    }

    public Text create(Composite parent, int style) {
        Text newItem = new Text(parent, style);
        newItem.setTextLimit(17);
        newItem.setText("00-00-00-00-00-00");
        newItem.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                MacAddressTextFactory.this.autoCompleteCheck(t);
                if (MacAddressController.isComplete((String)t.getText())) {
                    t.setForeground(null);
                } else {
                    t.setForeground(ColorConstants.red);
                }
            }
        });
        newItem.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.replace('.', '-');
                String text = e.text = e.text.replace(':', '-');
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if (!('0' <= chars[i] && chars[i] <= '9' || 'a' <= chars[i] && chars[i] <= 'f' || 'A' <= chars[i] && chars[i] <= 'F' || chars[i] == '-')) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        return newItem;
    }

    private void autoCompleteCheck(Text t) {
        String text = t.getText();
        if (text.length() == 12 && text.indexOf("-") == -1) {
            String mac1 = text.substring(0, 2);
            String mac2 = text.substring(2, 4);
            String mac3 = text.substring(4, 6);
            String mac4 = text.substring(6, 8);
            String mac5 = text.substring(8, 10);
            String mac6 = text.substring(10, 12);
            text = String.valueOf(mac1) + "-" + mac2 + "-" + mac3 + "-" + mac4 + "-" + mac5 + "-" + mac6;
            t.setText(text);
        }
    }
}

