/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.tree;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerControlIdentifier;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerTreeViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class ByteBlowerTreeColumn
extends TreeColumn
implements ControlListener {
    private static final String CONTROL_WITHOUT_IDENTIFIER = "CONTROL_WITHOUT_IDENTIFIER";
    private ByteBlowerTreeViewer viewer;
    private static int MIN_WIDTH = 10;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$gui$swt$sorting$ByteBlowerComparator$Direction = ByteBlowerTreeColumn.$SWITCH_TABLE$com$excentis$products$byteblower$gui$swt$sorting$ByteBlowerComparator$Direction();
    }

    public ByteBlowerTreeColumn(ByteBlowerTreeViewer viewer, int index, String columnName) {
        super(viewer.getTree(), 16384);
        this.setMoveable(true);
        this.setResizable(true);
        this.setText(columnName);
        this.setToolTipText(columnName);
        this.addControlListener(this);
        this.viewer = viewer;
        this.updateHeaderSorting();
        this.addSelectionListener((SelectionListener)this.getSelectionAdapter(this, index));
    }

    private void updateHeaderSorting() {
        ByteBlowerComparator comparator = this.viewer.getViewerComparator();
        if (comparator != null && comparator.isDynamic()) {
            ByteBlowerComparator.Direction dir = comparator.getDirection();
            int columnIndex = comparator.getColumn();
            Tree tree = this.viewer.getTree();
            if (tree.getColumnCount() > columnIndex) {
                switch (dir) {
                    case ASCENDING: {
                        tree.setSortDirection(128);
                        TreeColumn column = tree.getColumn(columnIndex);
                        tree.setSortColumn(column);
                        break;
                    }
                    case DESCENDING: {
                        tree.setSortDirection(1024);
                        TreeColumn column = tree.getColumn(columnIndex);
                        tree.setSortColumn(column);
                        break;
                    }
                    case OFF: {
                        tree.setSortDirection(0);
                        tree.setSortColumn(null);
                    }
                }
            }
        }
    }

    private SelectionAdapter getSelectionAdapter(TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerComparator comparator = ByteBlowerTreeColumn.this.viewer.getViewerComparator();
                if (comparator != null && comparator.isDynamic()) {
                    comparator.toggleSortingColumn(index);
                    ByteBlowerTreeColumn.this.updateHeaderSorting();
                    ByteBlowerTreeColumn.this.viewer.hardRefresh();
                }
            }
        };
        return selectionAdapter;
    }

    public void restoreWidth() {
        int width = this.getStoredColumnWidth();
        if (width < MIN_WIDTH) {
            width = MIN_WIDTH;
        }
        this.setWidth(width);
    }

    public int getStoredColumnWidth() {
        String identifier = this.getIdentifier();
        return ByteBlowerPreferences.getStoredColumnWidth((String)identifier);
    }

    protected void checkSubclass() {
    }

    public void storeWidth() {
        String identifier = this.getIdentifier();
        int width = this.getWidth();
        ByteBlowerPreferences.storeColumnWidth((String)identifier, (int)width);
    }

    String getIdentifier() {
        String identifier = this.getControlIdentifier((Widget)this);
        String columnName = this.getText();
        return "TreeColumn." + identifier + "." + columnName;
    }

    private String getControlIdentifier(Widget widget) {
        if (widget != null) {
            Control control;
            Composite parent;
            if (widget instanceof ByteBlowerTreeColumn) {
                ByteBlowerTreeColumn column = (ByteBlowerTreeColumn)widget;
                Tree parent2 = column.getParent();
                return this.getControlIdentifier((Widget)parent2);
            }
            if (widget instanceof ByteBlowerControlIdentifier) {
                ByteBlowerControlIdentifier identifier = (ByteBlowerControlIdentifier)widget;
                return identifier.getIdentifier();
            }
            if (widget instanceof Control && (parent = (control = (Control)widget).getParent()) != null) {
                return this.getControlIdentifier((Widget)parent);
            }
        }
        return CONTROL_WITHOUT_IDENTIFIER;
    }

    public void controlMoved(ControlEvent arg0) {
    }

    public void controlResized(ControlEvent arg0) {
        this.storeWidth();
    }

    public boolean hasStoredWidth() {
        int width = this.getStoredColumnWidth();
        return width != -1;
    }
}

