/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.update;

import com.excentis.products.byteblower.gui.update.Activator;
import com.excentis.products.byteblower.gui.update.P2Util;
import com.excentis.products.byteblower.gui.utils.OSValidator;
import com.excentis.products.byteblower.utils.Utils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.storage.StorageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

class UpdateJob
extends Job {
    private final IProvisioningAgent agent;
    private IStatus result;
    private boolean isAutoUpdate;

    UpdateJob(IProvisioningAgent agent, boolean auto) {
        super("Checking for updates");
        this.agent = agent;
        this.isAutoUpdate = auto;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.result = this.isAutoUpdate ? P2Util.checkForUpdates(this.agent, null) : P2Util.checkForUpdates(this.agent, monitor);
        if (this.result.getCode() == 10000) {
            Activator.log(1, "Nothing to update");
            if (!this.isAutoUpdate) {
                this.popUpInformation("Nothing to update!");
            }
            return this.result;
        }
        if (this.result.getSeverity() == 8) {
            Activator.log(1, "Update canceled");
            return this.result;
        }
        UpdateJob.logInfo("ByteBlower Update: Updates found");
        if (OSValidator.isMac()) {
            this.suggestInstaller();
        } else {
            this.installUpdates();
        }
        return this.result;
    }

    private static final void logInfo(String message) {
        Activator.log(1, message);
    }

    private static final void logError(String message) {
        Activator.log(1, message);
    }

    private void suggestInstaller() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String title = "GUI Software Updates Available";
                String info = "An updated version of ByteBlower GUI is now available. By updating, you'll gain access to the";
                info = String.valueOf(info) + " latest features and enhancements. Click \"Download Now\" to proceed to the latest version download page.";
                int button = MessageDialog.open((int)2, null, (String)title, (String)info, (int)8, (String[])new String[]{"Download Now", "Later"});
                if (button == 0) {
                    UpdateJob.browseToSetupPage();
                }
            }
        });
    }

    private static void browseToSetupPage() {
        try {
            URI link = new URI("https://setup.byteblower.com/software.html#GUI");
            Desktop.getDesktop().browse(link);
        }
        catch (IOException | URISyntaxException e) {
            String msg = String.format("Not able to browse to the setup pages: %e", e.getMessage());
            UpdateJob.logError(msg);
        }
    }

    private void installUpdates() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean install;
                Shell shell = Display.getDefault().getActiveShell();
                String info = "New updates found for the GUI.\n\n";
                if (Utils.running32Bit()) {
                    info = String.valueOf(info) + "Instead of updating, we advise you to download and install the 64-bit version from https://setup.byteblower.com.\nYou are currently running a 32-bit version which will soon be deprecated.\n\n";
                }
                if (!UpdateJob.this.verifyPermissions()) {
                    info = String.valueOf(info) + "To install the updates, restart the ByteBlower GUI as Administrator.";
                    UpdateJob.this.popUpInformation(info);
                    UpdateJob.this.result = new Status(4, "com.excentis.products.byteblower.gui.update", "Update failed! No write permissions in installdir.");
                    StatusManager.getManager().handle(UpdateJob.this.result);
                    install = false;
                } else {
                    info = String.valueOf(info) + "Would you like to update the ByteBlower GUI?\nThe application will be restarted after completion.";
                    install = MessageDialog.openQuestion(null, (String)"New updates", (String)info);
                }
                if (install) {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                    try {
                        dialog.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                IStatus status = P2Util.installUpdates((this).UpdateJob.this.agent, monitor);
                                UpdateJob.logInfo(String.format("ByteBlower update: %s with msg= %s", status.isOK(), status.getMessage()));
                                UpdateJob.this.restartWorkBench(status);
                            }
                        });
                    }
                    catch (Exception e) {
                        UpdateJob.logError("ByteBlower Update: Failed to install updates");
                        UpdateJob.this.result = new Status(4, "com.excentis.products.byteblower.gui.update", "Update failed!", (Throwable)e);
                        StatusManager.getManager().handle(UpdateJob.this.result);
                    }
                } else {
                    UpdateJob.logInfo("ByteBlower Update: Not installing updates");
                }
            }
        });
    }

    private void popUpInformation(final String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation(null, (String)"New updates", (String)message);
            }
        });
    }

    private void restartWorkBench(IStatus status) {
        final String message = status.isOK() ? "The ByteBlower GUI will now restart to complete the installation." : "The ByteBlower GUI failed to update. Please retry or reinstall GUI.\n" + status.getMessage();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation(null, (String)"Updates", (String)message);
                UpdateJob.logInfo("Update was successful. Restarting the ByteBlower GUI");
                boolean restartSuccess = PlatformUI.getWorkbench().restart();
                if (restartSuccess) {
                    UpdateJob.logInfo("ByteBlower Update: GUI was restarted successfully");
                } else {
                    UpdateJob.logError("ByteBlower Update: GUI was restarted successfully");
                }
            }
        });
    }

    private boolean verifyPermissions() {
        String installdir = Platform.getInstallLocation().getURL().getPath();
        File installdirFile = new File(installdir);
        boolean result = StorageUtil.canWrite((File)installdirFile);
        UpdateJob.logInfo(String.format("Can the GUI install updates? %s", result));
        return result;
    }
}

