/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.views.realtime.Activator;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.UIJob;

class PrometheusGraphicalStatus
extends UIJob
implements SelectionListener {
    private final Image offlineIcon = ImageCache.getImageFromString((String)"icons/open_metrics_bw.png");
    private final Image unusedIcon = ImageCache.getImageFromString((String)"icons/open_metrics_default.png");
    private final Image perfectIcon = ImageCache.getImageFromString((String)"icons/open_metrics_beat.png");
    private final String offlineText = "Offline. <a>Verify the config</a>";
    private final String unusedText = "<a>Configure Prometheus</a>";
    private final String perfectText = "Perfect! <a>Check the Examples</a>";
    private final String gettingStartedLink = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/getting-started-with-prometheus";
    private final String dashboardExamples = "https://excentis.github.io/grafana_dashboards";
    private final Label statusIcon;
    private final Link statusText;

    public static PrometheusGraphicalStatus buildUI(Composite prometheusNotification) {
        Label statusIcon = new Label(prometheusNotification, 0);
        Link statusText = new Link(prometheusNotification, 0);
        PrometheusGraphicalStatus result = new PrometheusGraphicalStatus(statusIcon, statusText);
        statusText.addSelectionListener((SelectionListener)result);
        result.start();
        return result;
    }

    private PrometheusGraphicalStatus(Label statusIcon, Link statusText) {
        super("Prometheus status updater");
        this.statusIcon = statusIcon;
        this.statusText = statusText;
        statusIcon.setImage(this.offlineIcon);
        statusText.setText("Offline. <a>Verify the config</a>");
    }

    public void start() {
        this.setSystem(true);
        this.schedule();
    }

    public IStatus runInUIThread(IProgressMonitor arg0) {
        if (this.statusText.isDisposed() || this.statusIcon.isDisposed()) {
            return Status.OK_STATUS;
        }
        switch (Activator.getDefault().prometheusState()) {
            case SCRAPED: {
                this.statusIcon.setImage(this.perfectIcon);
                this.statusText.setText("Perfect! <a>Check the Examples</a>");
                break;
            }
            case OFFLINE: {
                this.statusIcon.setImage(this.offlineIcon);
                this.statusText.setText("Offline. <a>Verify the config</a>");
                break;
            }
            case AVAILABLE: {
                this.statusIcon.setImage(this.unusedIcon);
                this.statusText.setText("<a>Configure Prometheus</a>");
            }
        }
        this.statusIcon.requestLayout();
        this.schedule(250L);
        return Status.OK_STATUS;
    }

    public void widgetSelected(SelectionEvent clicked) {
        String baseText = clicked.text;
        Shell shell = this.statusText.getShell();
        if (shell.isDisposed() || baseText == null) {
            return;
        }
        if (baseText.contains("config")) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"com.excentis.products.byteblower.gui.preferences.general", null, null);
            dialog.open();
        } else if (baseText.contains("Prometheus")) {
            this.browseToUrl("https://support.excentis.com/index.php?/Knowledgebase/Article/View/getting-started-with-prometheus");
        } else if (baseText.contains("Examples")) {
            this.browseToUrl("https://excentis.github.io/grafana_dashboards");
        }
    }

    private void browseToUrl(String strUrl) {
        try {
            URL url = new URL(strUrl);
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            browser.openURL(url);
        }
        catch (MalformedURLException | PartInitException throwable) {}
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }
}

