/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime.composites;

import com.excentis.products.byteblower.gui.views.realtime.composites.RealtimeFlowsComposite;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.utils.Pair;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;

abstract class FlowsLabelProvider
extends CellLabelProvider {
    private RealtimeFlowsComposite flowInstanceTableViewer;
    private boolean shouldBlink;

    FlowsLabelProvider(RealtimeFlowsComposite flowInstanceTableViewer, boolean shouldBlink) {
        this.flowInstanceTableViewer = flowInstanceTableViewer;
        this.shouldBlink = shouldBlink;
    }

    public void update(ViewerCell cell) {
        String newText = "UNSUPPORTED ELEMENT!";
        Object element = cell.getElement();
        if (element instanceof Pair) {
            Pair pair = (Pair)element;
            Object first = pair.getFirst();
            Object second = pair.getSecond();
            if (first instanceof FlowInstance) {
                newText = this.deriveValue((FlowInstance)first, second);
            }
        }
        this.setColors(cell);
        cell.setText(newText);
    }

    protected abstract String deriveValue(FlowInstance var1, Object var2);

    private void setColors(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof Pair) {
            Pair pair = (Pair)element;
            if (pair.getFirst() instanceof FlowInstance) {
                cell.setForeground(this.shouldBlink ? this.blinkColor(cell) : ByteBlowerColor.darkgrey);
                cell.setBackground(this.getAlternatingBackgroundColor((FlowInstance)pair.getFirst()));
            } else {
                cell.setForeground(ByteBlowerColor.red);
                cell.setBackground(null);
            }
        } else {
            cell.setForeground(ByteBlowerColor.red);
            cell.setBackground(null);
        }
    }

    private Color blinkColor(ViewerCell cell) {
        Color previousColor = cell.getForeground();
        if (previousColor.equals((Object)ByteBlowerColor.black)) {
            return ByteBlowerColor.darkgrey;
        }
        return ByteBlowerColor.black;
    }

    private Color getAlternatingBackgroundColor(FlowInstance flowInstance) {
        Color defaultColor = null;
        int idx = this.flowInstanceTableViewer.getIndex(flowInstance);
        if (idx < 0) {
            return ByteBlowerColor.red;
        }
        if (idx % 2 == 0) {
            return ByteBlowerColor.lightBlue;
        }
        return defaultColor;
    }
}

