/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime.composites;

import com.excentis.products.byteblower.gui.views.realtime.composites.RealtimePortsComposite;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;

abstract class PortLabelProvider
extends CellLabelProvider {
    private final RealtimePortsComposite portReference;

    public PortLabelProvider(RealtimePortsComposite source) {
        this.portReference = source;
    }

    public void update(ViewerCell cell) {
        this.applySharedLabelProviderConfig(cell);
        cell.setText(this.deriveValue(cell.getElement()));
    }

    abstract String deriveValue(Object var1);

    private void applySharedLabelProviderConfig(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setForeground(ByteBlowerColor.darkgrey);
        if (element instanceof Port) {
            cell.setBackground(this.getBackgroundColor((Port)element));
        } else if (element instanceof Layer3) {
            cell.setBackground(this.getBackgroundColor(((Layer3)element).getPort()));
        } else if (element instanceof Layer3Ipv4Session) {
            cell.setBackground(this.getBackgroundColor(((Layer3Ipv4Session)element).getConfiguration().getPort()));
        } else if (element instanceof Layer3Ipv6Session) {
            cell.setBackground(this.getBackgroundColor(((Layer3Ipv6Session)element).getConfiguration().getPort()));
        } else if (element instanceof Layer3Ipv6SessionAddress) {
            cell.setBackground(this.getBackgroundColor(((Layer3Ipv6SessionAddress)element).getPrefix().getSession().getConfiguration().getPort()));
        } else {
            cell.setBackground(ByteBlowerColor.red);
        }
    }

    private Color getBackgroundColor(Port port) {
        int idx = this.portReference.indexOf(port);
        if (idx < 0) {
            return ByteBlowerColor.red;
        }
        if (idx % 2 == 0) {
            return ByteBlowerColor.lightBlue;
        }
        return null;
    }
}

