/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime.composites;

import com.excentis.products.byteblower.gui.views.realtime.composites.PortLabelProvider;
import com.excentis.products.byteblower.gui.views.realtime.composites.PortLayer3TableContentProvider;
import com.excentis.products.byteblower.gui.views.realtime.util.IndexedSet;
import com.excentis.products.byteblower.gui.views.realtime.util.WatchDogValue;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceConversionError;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionGateway;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.enums.PortStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.ScenarioStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.ServerType;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv6AddressUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RealtimePortsComposite
extends Composite {
    private TableViewer dataViewer;
    private Map<EViewerColumn, TableViewerColumn> columnMap = new HashMap<EViewerColumn, TableViewerColumn>();
    private IndexedSet<Port> cachedPortList;
    private ScenarioStatus scenarioStatus = ScenarioStatus.CREATED;

    public RealtimePortsComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        Label titleLabel = new Label((Composite)this, 0);
        titleLabel.setLayoutData((Object)new GridData(0, 0, true, false));
        this.dataViewer = new TableViewer((Composite)this, 68098);
        this.dataViewer.getTable().setHeaderVisible(true);
        this.dataViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        titleLabel.setText("Ports");
        EViewerColumn[] eViewerColumnArray = EViewerColumn.values();
        int n = eViewerColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            EViewerColumn eColumn = eViewerColumnArray[n2];
            TableViewerColumn viewerColumn = new TableViewerColumn(this.dataViewer, 0);
            this.columnMap.put(eColumn, viewerColumn);
            viewerColumn.getColumn().setText(eColumn.getColumnTitle());
            viewerColumn.setLabelProvider(this.createLabelProvider(eColumn));
            ++n2;
        }
        this.dataViewer.getTable().getParent().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                RealtimePortsComposite.this.resizeTableColumns();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.resizeTableColumns();
        this.dataViewer.setContentProvider((IContentProvider)new PortLayer3TableContentProvider());
        this.dataViewer.setInput(null);
        this.setEnabled(false);
    }

    public void resetInput() {
        this.cachedPortList = new IndexedSet(null);
        this.scenarioStatus = ScenarioStatus.FINISHED;
        this.dataViewer.setInput(null);
    }

    public void updateInput(ScenarioStatus scenarioStatus, List<Port> portList) {
        this.cachedPortList = new IndexedSet<Port>(portList);
        this.scenarioStatus = scenarioStatus;
        this.dataViewer.setInput(portList);
    }

    private CellLabelProvider createLabelProvider(EViewerColumn eColumn) {
        switch (eColumn) {
            case PORT: {
                return new PortLabel();
            }
            case TYPE: {
                return new PortConfigType();
            }
            case ADDRESS: {
                return new PortAddress();
            }
            case PREFIX_LENGTH: {
                return new PrefixLength();
            }
            case GATEWAY_ADDRESS: {
                return new GatewayAddress();
            }
        }
        return new EmptyLabel(eColumn);
    }

    private void resizeTableColumns() {
        TableLayout tableLayout = new TableLayout();
        EViewerColumn[] eViewerColumnArray = EViewerColumn.values();
        int n = eViewerColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            EViewerColumn eColumn = eViewerColumnArray[n2];
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(eColumn.getColumnWeight(), true));
            ++n2;
        }
        this.dataViewer.getTable().setLayout((Layout)tableLayout);
    }

    public void setEnabled(boolean enabled) {
        this.dataViewer.getTable().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public int indexOf(Port port) {
        if (this.cachedPortList == null) {
            return -1;
        }
        return this.cachedPortList.indexOf(port);
    }

    private static enum EViewerColumn {
        PORT("Port", 20),
        TYPE("Type", 15),
        ADDRESS("Address", 10),
        PREFIX_LENGTH("Prefix length", 10),
        GATEWAY_ADDRESS("Gateway", 30);

        private String columnTitle;
        private int columnWeight;

        private EViewerColumn(String columnTitle, int columnWeight) {
            this.columnTitle = columnTitle;
            this.columnWeight = columnWeight;
        }

        private String getColumnTitle() {
            return this.columnTitle;
        }

        private int getColumnWeight() {
            return this.columnWeight;
        }
    }

    private final class EmptyLabel
    extends PortLabelProvider {
        private final EViewerColumn eColumn;

        private EmptyLabel(EViewerColumn eColumn) {
            super(RealtimePortsComposite.this);
            this.eColumn = eColumn;
        }

        @Override
        String deriveValue(Object element) {
            return "#WARNING: unhandled column " + this.eColumn.toString();
        }
    }

    private final class GatewayAddress
    extends PortLabelProvider {
        Map<Port, WatchDogValue> alivePorts;

        private GatewayAddress() {
            super(RealtimePortsComposite.this);
            this.alivePorts = new HashMap<Port, WatchDogValue>();
        }

        private String deriveForWep(Port dbPort) {
            WatchDogValue watch = this.alivePorts.computeIfAbsent(dbPort, p -> new WatchDogValue());
            ArrayList<String> displayElements = new ArrayList<String>();
            if (RealtimePortsComposite.this.scenarioStatus != ScenarioStatus.RUNNING || watch.isStillAlive(dbPort.lastSeen)) {
                if (dbPort.rssi != -127L) {
                    displayElements.add(String.format("RSSI = %ddBm", dbPort.rssi));
                }
                if (!dbPort.ssid.equals("")) {
                    displayElements.add(String.format("SSID = '%s'", dbPort.ssid));
                }
                if (!dbPort.ssid.equals("")) {
                    displayElements.add(String.format("BSSID = %s", dbPort.bssid));
                }
            }
            return String.join((CharSequence)" / ", displayElements);
        }

        @Override
        public String deriveValue(Object element) {
            if (element instanceof Layer3Ipv4Session) {
                Ipv4Address address = ((Layer3Ipv4Session)element).getGatewayAddress();
                Layer3Ipv4 config = ((Layer3Ipv4Session)element).getConfiguration();
                if (config != null && config.getPort() != null && config.getPort().isDockedMobile()) {
                    Port port = config.getPort();
                    return this.deriveForWep(port);
                }
                if (address != null && address.isValid()) {
                    try {
                        return Ipv4AddressUtility.convertToString((byte[])address.getAddress());
                    }
                    catch (TestDataPersistenceConversionError testDataPersistenceConversionError) {
                        return "Non-parsable IPv4 address bytes " + address.getAddress();
                    }
                }
                return "";
            }
            if (element instanceof Layer3Ipv6Session) {
                Layer3Ipv6 config = ((Layer3Ipv6Session)element).getConfiguration();
                if (config != null && config.getPort() != null && config.getPort().isDockedMobile()) {
                    Port port = config.getPort();
                    return this.deriveForWep(port);
                }
                Set gateways = ((Layer3Ipv6Session)element).getGatewayAddresses();
                for (Layer3Ipv6SessionGateway gateway : gateways) {
                    Ipv6Address address = gateway.getIpv6Address();
                    if (Ipv6AddressUtility.isValid((Ipv6Address)address)) continue;
                    try {
                        return Ipv6AddressUtility.convertToExpandedString((byte[])address.getAddress());
                    }
                    catch (TestDataPersistenceConversionError testDataPersistenceConversionError) {
                        return "Non-parsable IPv6 address bytes " + address.getAddress();
                    }
                }
                return "";
            }
            return "";
        }
    }

    private final class PortAddress
    extends PortLabelProvider {
        private PortAddress() {
            super(RealtimePortsComposite.this);
        }

        @Override
        public String deriveValue(Object element) {
            if (element instanceof Layer3Ipv4Session) {
                Ipv4Address address = ((Layer3Ipv4Session)element).getAddress();
                if (address != null) {
                    try {
                        return Ipv4AddressUtility.convertToString((byte[])address.getAddress());
                    }
                    catch (TestDataPersistenceConversionError testDataPersistenceConversionError) {
                        return "Non-parsable IPv4 address bytes " + address.getAddress();
                    }
                }
                return "";
            }
            if (element instanceof Layer3Ipv6Session) {
                Ipv6Address address = ((Layer3Ipv6Session)element).getLinkLocalAddress();
                try {
                    return Ipv6AddressUtility.convertToExpandedString((byte[])address.getAddress());
                }
                catch (TestDataPersistenceConversionError testDataPersistenceConversionError) {
                    return "Non-parsable IPv6 address bytes " + address.getAddress();
                }
            }
            if (element instanceof Layer3Ipv6SessionAddress) {
                Ipv6Address address = ((Layer3Ipv6SessionAddress)element).getIpv6Address();
                try {
                    return Ipv6AddressUtility.convertToExpandedString((byte[])address.getAddress());
                }
                catch (TestDataPersistenceConversionError testDataPersistenceConversionError) {
                    return "Non-parsable IPv6 address bytes " + address.getAddress();
                }
            }
            return "";
        }
    }

    private final class PortConfigType
    extends PortLabelProvider {
        private PortConfigType() {
            super(RealtimePortsComposite.this);
        }

        @Override
        public String deriveValue(Object element) {
            if (element instanceof Layer3Ipv4Session) {
                Layer3Ipv4Session layer3 = (Layer3Ipv4Session)element;
                ServerType type = layer3.getConfiguration().getPort().getInterface().getServer().getType();
                if (type == ServerType.MEETING_POINT) {
                    return "Mobile Device";
                }
                if (((Layer3Ipv4Session)element).getConfiguration().getDhcpConfiguration() != null) {
                    return "DHCPv4";
                }
                if (((Layer3Ipv4Session)element).getConfiguration().getFixedConfiguration() != null) {
                    return "Fixed";
                }
                return "#WARNING: Neither DHCPv4 nor Fixed configuration found";
            }
            if (element instanceof Layer3Ipv6Session) {
                return "Link-local";
            }
            if (element instanceof Layer3Ipv6SessionAddress) {
                switch (((Layer3Ipv6SessionAddress)element).getType()) {
                    case DHCP_AUTO: 
                    case DHCP_FORCED: {
                        return "DHCPv6";
                    }
                    case SLAAC_AUTO_MAC: 
                    case SLAAC_AUTO_RANDOM: 
                    case SLAAC_FORCED_MAC: 
                    case SLAAC_FORCED_RANDOM: {
                        return "Stateless Autoconfiguration";
                    }
                    case FIXED: {
                        return "Fixed";
                    }
                }
                return "#WARNING: Unknown IPv6 address type " + ((Layer3Ipv6SessionAddress)element).getType();
            }
            return "";
        }
    }

    private class PortLabel
    extends PortLabelProvider {
        private PortLabel() {
            super(RealtimePortsComposite.this);
        }

        @Override
        public void update(ViewerCell cell) {
            super.update(cell);
            Port port = this.getPort(cell.getElement());
            if (port != null && port.getStatus() == PortStatus.CONFIGURATION_ERROR) {
                cell.setForeground(ByteBlowerColor.red);
            }
        }

        @Override
        public String deriveValue(Object element) {
            if (element instanceof Port) {
                return ((Port)element).getName();
            }
            if (element instanceof Layer3) {
                return ((Layer3)element).getPort().getName();
            }
            if (element instanceof Layer3Ipv4Session) {
                return ((Layer3Ipv4Session)element).getConfiguration().getPort().getName();
            }
            if (element instanceof Layer3Ipv6Session) {
                return ((Layer3Ipv6Session)element).getConfiguration().getPort().getName();
            }
            return "";
        }

        private Port getPort(Object element) {
            if (element instanceof Port) {
                return (Port)element;
            }
            if (element instanceof Layer3) {
                return ((Layer3)element).getPort();
            }
            if (element instanceof Layer3Ipv4Session) {
                return ((Layer3Ipv4Session)element).getConfiguration().getPort();
            }
            if (element instanceof Layer3Ipv6Session) {
                return ((Layer3Ipv6Session)element).getConfiguration().getPort();
            }
            return null;
        }
    }

    private final class PrefixLength
    extends PortLabelProvider {
        private PrefixLength() {
            super(RealtimePortsComposite.this);
        }

        @Override
        public String deriveValue(Object element) {
            if (element instanceof Layer3Ipv4Session) {
                Integer prefixLength = ((Layer3Ipv4Session)element).getNetmask();
                if (prefixLength != null && prefixLength != 0) {
                    return "" + prefixLength;
                }
                return "";
            }
            if (element instanceof Layer3Ipv6Session) {
                Integer prefixlength = 64;
                return "" + prefixlength;
            }
            if (element instanceof Layer3Ipv6SessionAddress) {
                return "" + ((Layer3Ipv6SessionAddress)element).getPrefix().getPrefixLength();
            }
            return "";
        }
    }
}

